/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RejectingServer
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(RejectingServer.class);
    private final InetSocketAddress mAddress;
    private ServerSocket mServerSocket;

    public RejectingServer(InetSocketAddress address) {
        super("RejectingServer-" + address);
        this.mAddress = address;
    }

    @Override
    public void run() {
        try {
            this.mServerSocket = new ServerSocket();
            this.mServerSocket.bind(this.mAddress);
            this.mServerSocket.setReuseAddress(true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        while (!Thread.interrupted()) {
            try {
                Socket s = this.mServerSocket.accept();
                s.close();
            }
            catch (SocketException e) {
                return;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void stopAndJoin() {
        this.interrupt();
        if (this.mServerSocket != null) {
            try {
                this.mServerSocket.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.join(5000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (this.isAlive()) {
            LOG.warn("Failed to stop rejecting server thread");
        }
    }
}

