/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics;

import com.codahale.metrics.CachedGauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.sun.management.OperatingSystemMXBean;
import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class OperationSystemGaugeSet
implements MetricSet {
    private OperatingSystemMXBean mOsmxb;
    private UnixOperatingSystemMXBean mUnixb;

    public Map<String, Metric> getMetrics() {
        HashMap<String, Metric> gauges = new HashMap<String, Metric>();
        try {
            this.mOsmxb = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            this.mUnixb = (UnixOperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        }
        catch (Throwable e) {
            return gauges;
        }
        gauges.put("os.freePhysicalMemory", (Metric)new CachedGauge(10L, TimeUnit.MINUTES){

            protected Long loadValue() {
                return OperationSystemGaugeSet.this.mOsmxb.getFreePhysicalMemorySize();
            }
        });
        gauges.put("os.totalPhysicalMemory", (Metric)new CachedGauge<Long>(10L, TimeUnit.MINUTES){

            protected Long loadValue() {
                return OperationSystemGaugeSet.this.mOsmxb.getTotalPhysicalMemorySize();
            }
        });
        gauges.put("os.cpuLoad", (Metric)new CachedGauge<Double>(10L, TimeUnit.MINUTES){

            protected Double loadValue() {
                return OperationSystemGaugeSet.this.mOsmxb.getSystemCpuLoad();
            }
        });
        gauges.put("os.maxFileCount", (Metric)new CachedGauge<Long>(10L, TimeUnit.MINUTES){

            protected Long loadValue() {
                return OperationSystemGaugeSet.this.mUnixb.getMaxFileDescriptorCount();
            }
        });
        gauges.put("os.openFileCount", (Metric)new CachedGauge<Long>(10L, TimeUnit.MINUTES){

            protected Long loadValue() {
                return OperationSystemGaugeSet.this.mUnixb.getOpenFileDescriptorCount();
            }
        });
        return gauges;
    }
}

