/*
 * Decompiled with CFR 0.152.
 */
package alluxio.heartbeat;

import alluxio.heartbeat.HeartbeatScheduler;
import alluxio.heartbeat.HeartbeatTimer;
import alluxio.resource.LockResource;
import com.google.common.base.Preconditions;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ScheduledTimer
implements HeartbeatTimer {
    private final String mThreadName;
    private final Lock mLock;
    private final Condition mTickCondition;
    private volatile boolean mScheduled;

    public ScheduledTimer(String threadName, long intervalMs) {
        this.mThreadName = threadName;
        this.mLock = new ReentrantLock();
        this.mTickCondition = this.mLock.newCondition();
        this.mScheduled = false;
        HeartbeatScheduler.clearTimer(this.mThreadName);
    }

    public String getThreadName() {
        return this.mThreadName;
    }

    protected void schedule() {
        try (LockResource r = new LockResource(this.mLock);){
            Preconditions.checkState((!this.mScheduled ? 1 : 0) != 0, (Object)"Called schedule twice without waiting for any ticks");
            this.mScheduled = true;
            this.mTickCondition.signal();
            HeartbeatScheduler.removeTimer(this);
        }
    }

    @Override
    public void tick() throws InterruptedException {
        try (LockResource r = new LockResource(this.mLock);){
            HeartbeatScheduler.addTimer(this);
            while (!this.mScheduled) {
                this.mTickCondition.await();
            }
            this.mScheduled = false;
        }
    }
}

