/*
 * Decompiled with CFR 0.152.
 */
package alluxio.conf.path;

import alluxio.collections.Pair;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Function;

public final class TrieNode {
    private Map<String, TrieNode> mChildren = new HashMap<String, TrieNode>();
    private boolean mIsTerminal = false;

    public TrieNode insert(String path) {
        TrieNode current = this;
        for (String component : path.split("/")) {
            if (!current.mChildren.containsKey(component)) {
                current.mChildren.put(component, new TrieNode());
            }
            current = current.mChildren.get(component);
        }
        current.mIsTerminal = true;
        return current;
    }

    public List<TrieNode> search(String path) {
        ArrayList<TrieNode> terminal = new ArrayList<TrieNode>();
        TrieNode current = this;
        if (current.mIsTerminal) {
            terminal.add(current);
        }
        for (String component : path.split("/")) {
            if (!current.mChildren.containsKey(component)) break;
            current = current.mChildren.get(component);
            if (!current.mIsTerminal) continue;
            terminal.add(current);
        }
        return terminal;
    }

    public boolean hasTerminal(String path, boolean includeChildren) {
        TrieNode current = this;
        if (current.mIsTerminal) {
            return true;
        }
        for (String component : path.split("/")) {
            TrieNode child = current.mChildren.get(component);
            if (child != null) {
                current = child;
                if (!current.mIsTerminal) continue;
                return true;
            }
            return false;
        }
        return includeChildren;
    }

    public TrieNode deleteIf(String path, Function<TrieNode, Boolean> predicate) {
        Stack<Pair<TrieNode, String>> parents = new Stack<Pair<TrieNode, String>>();
        TrieNode current = this;
        for (String component : path.split("/")) {
            if (!current.mChildren.containsKey(component)) {
                return null;
            }
            parents.push(new Pair<TrieNode, String>(current, component));
            current = current.mChildren.get(component);
        }
        if (!current.mIsTerminal) {
            return null;
        }
        if (!predicate.apply(current).booleanValue()) {
            return null;
        }
        TrieNode nodeToDelete = current;
        current.mIsTerminal = false;
        while (current.mChildren.isEmpty() && !current.mIsTerminal && !parents.empty()) {
            Pair parent = (Pair)parents.pop();
            current = (TrieNode)parent.getFirst();
            current.mChildren.remove(parent.getSecond());
        }
        return nodeToDelete;
    }

    public Iterator<TrieNode> getCommonRoots() {
        if (this.mIsTerminal) {
            return Collections.singletonList(this).iterator();
        }
        return Iterators.concat(this.mChildren.values().stream().map(TrieNode::getCommonRoots).iterator());
    }
}

