/*
 * Decompiled with CFR 0.152.
 */
package alluxio.conf;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.codec.binary.Hex;

@ThreadSafe
public final class Hash {
    private final MessageDigest mMD5;
    private final Supplier<Stream<byte[]>> mProperties;
    private final AtomicBoolean mShouldUpdate;
    private volatile String mVersion;

    public Hash(Supplier<Stream<byte[]>> properties) {
        try {
            this.mMD5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.mProperties = properties;
        this.mShouldUpdate = new AtomicBoolean(true);
    }

    public void markOutdated() {
        this.mShouldUpdate.set(true);
    }

    private String compute() {
        this.mMD5.reset();
        this.mProperties.get().forEach(property -> this.mMD5.update((byte[])property));
        return Hex.encodeHexString((byte[])this.mMD5.digest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get() {
        if (this.mShouldUpdate.get()) {
            Hash hash = this;
            synchronized (hash) {
                if (this.mShouldUpdate.get()) {
                    this.mVersion = this.compute();
                    this.mShouldUpdate.set(false);
                }
            }
        }
        return this.mVersion;
    }
}

