/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.AbstractClient;
import alluxio.exception.status.UnavailableException;
import alluxio.master.MasterClientContext;
import alluxio.master.MasterInquireClient;
import alluxio.retry.RetryPolicy;
import java.net.InetSocketAddress;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AbstractMasterClient
extends AbstractClient {
    private final MasterInquireClient mMasterInquireClient;

    public AbstractMasterClient(MasterClientContext clientConf) {
        super(clientConf, null);
        this.mMasterInquireClient = clientConf.getMasterInquireClient();
    }

    public AbstractMasterClient(MasterClientContext clientConf, InetSocketAddress address, Supplier<RetryPolicy> retryPolicySupplier) {
        super(clientConf, address, retryPolicySupplier);
        this.mMasterInquireClient = clientConf.getMasterInquireClient();
    }

    @Override
    public synchronized InetSocketAddress getAddress() throws UnavailableException {
        return this.mMasterInquireClient.getPrimaryRpcAddress();
    }

    @Override
    public synchronized InetSocketAddress getConfAddress() throws UnavailableException {
        if (this.mAddress != null) {
            return this.mAddress;
        }
        return this.mMasterInquireClient.getPrimaryRpcAddress();
    }
}

