/*
 * The Alluxio Open Foundation licenses this work under the Apache License, version 2.0
 * (the "License"). You may not use this work except in compliance with the License, which is
 * available at www.apache.org/licenses/LICENSE-2.0
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied, as more fully set forth in the License.
 *
 * See the NOTICE file distributed with this work for information regarding copyright ownership.
 */

package alluxio;

/**
 * Project constants from compilation time by maven.
 */
public final class ProjectConstants {
  /* Project version, specified in maven property. **/
  public static final String VERSION = "2.8.0";
  /* The latest git revision of at the time of building**/
  public static final String REVISION = "bcb29e5a8e5bab1f4559b38c161e090a51c3fa8f";
  /* Hadoop version, specified in maven property. **/
  public static final String HADOOP_VERSION = "3.3.1";
  /* Whether update check is enabled. **/
  public static final String UPDATE_CHECK_ENABLED = "true";
  /* Update check host. **/
  public static final String UPDATE_CHECK_HOST = "https://diagnostics.alluxio.io";
  /* Update check auth string. **/
  public static final String UPDATE_CHECK_MAGIC_NUMBER = "YWxsdXhpbzp0YWNoeW9u";

  private ProjectConstants() {} // prevent instantiation
}
