/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.crystalball.simulator;

import java.util.Date;
import java.util.Map;
import org.springframework.beans.factory.FactoryBean;

public class SimulationEvent {
    public static final String TYPE_ACQUIRE_JOB_NOTIFICATION_EVENT = "ACQUIRE_JOB_NOTIFICATION_EVENT";
    public static final String TYPE_END_SIMULATION = "END_SIMULATION";
    public static final String TYPE_BREAK_SIMULATION = "BREAK";
    public static final int PRIORITY_SYSTEM = -1;
    private final long simulationTime;
    private final String type;
    private final Map<String, Object> properties;
    private final Object property;
    private final int priority;

    protected SimulationEvent(Builder builder) {
        this.simulationTime = builder.simulationTime;
        this.type = builder.type;
        this.properties = builder.properties;
        this.property = builder.property;
        this.priority = builder.priority;
    }

    public Object getProperty() {
        return this.property;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public long getSimulationTime() {
        return this.simulationTime;
    }

    public String getType() {
        return this.type;
    }

    public int getPriority() {
        return this.priority;
    }

    public String toString() {
        String date = this.hasSimulationTime() ? new Date(this.simulationTime).toString() + ", " : "now ";
        return date + this.type + ", " + this.priority + ", " + this.property + ", " + this.properties;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public boolean hasSimulationTime() {
        return this.simulationTime != Long.MIN_VALUE;
    }

    public static class Factory
    implements FactoryBean<SimulationEvent> {
        private long simulationTime;
        private String type;
        private Map<String, Object> properties;
        private int priority;

        public Factory(String type, long simulationTime, Map<String, Object> properties) {
            this.type = type;
            this.simulationTime = simulationTime;
            this.properties = properties;
        }

        public SimulationEvent getObject() throws Exception {
            return new Builder(this.type).simulationTime(this.simulationTime).properties(this.properties).priority(this.priority).build();
        }

        public Class<?> getObjectType() {
            return SimulationEvent.class;
        }

        public boolean isSingleton() {
            return false;
        }
    }

    public static class Builder {
        private long simulationTime;
        private String type;
        private Map<String, Object> properties;
        private Object property;
        private int priority;

        public Builder(String type) {
            this.type = type;
            this.simulationTime = Long.MIN_VALUE;
        }

        public Builder simulationTime(long simulationTime) {
            this.simulationTime = simulationTime;
            return this;
        }

        public Builder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public Builder property(Object property) {
            this.property = property;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public SimulationEvent build() {
            return new SimulationEvent(this);
        }
    }
}

