/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui.jtreetable;

import jadex.commons.gui.jtreetable.DefaultTreeTableNode;
import jadex.commons.gui.jtreetable.JTreeTable;
import jadex.commons.gui.jtreetable.TreeTableAction;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;

public class TreeTablePopupListener
extends MouseAdapter {
    @Override
    public void mousePressed(MouseEvent e) {
        this.doPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.doPopup(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.doPopup(e);
    }

    protected void doPopup(MouseEvent e) {
        JTreeTable table;
        TreePath path;
        if (e.isPopupTrigger() && (path = (table = (JTreeTable)e.getSource()).getTree().getPathForLocation(e.getX(), e.getY())) != null) {
            DefaultTreeTableNode node = (DefaultTreeTableNode)path.getLastPathComponent();
            int row = table.rowAtPoint(e.getPoint());
            int[] selrows = table.getSelectedRows();
            boolean newsel = true;
            for (int i = 0; newsel && i < selrows.length; ++i) {
                if (selrows[i] != row) continue;
                newsel = false;
            }
            if (newsel) {
                table.clearSelection();
                table.addRowSelectionInterval(row, row);
            }
            if (node.getType().getPopupActions().length > 0) {
                Action[] actions = node.getType().getPopupActions();
                JPopupMenu menu = new JPopupMenu("Actions");
                for (int i = 0; i < actions.length; ++i) {
                    JMenuItem item;
                    actions[i].putValue("node", node);
                    if (actions[i] instanceof TreeTableAction) {
                        item = new JCheckBoxMenuItem(actions[i]);
                        item.setSelected(((TreeTableAction)actions[i]).isSelected());
                        menu.add(item);
                        continue;
                    }
                    item = new JMenuItem(actions[i]);
                    menu.add(item);
                }
                if (actions.length > 0) {
                    menu.show(table, e.getX(), e.getY());
                }
            }
        }
    }
}

