/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui.jtreetable;

import jadex.commons.gui.jtreetable.TreeTableModel;
import jadex.commons.gui.jtreetable.TreeTableNode;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;

public class TreeTableModelAdapter
extends AbstractTableModel {
    JTree tree;
    TreeTableModel treeTableModel;

    public TreeTableModelAdapter(TreeTableModel treeTableModel, JTree tree) {
        this.tree = tree;
        this.treeTableModel = treeTableModel;
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                int row = TreeTableModelAdapter.this.tree.getRowForPath(event.getPath());
                if (row != -1) {
                    TreeTableModelAdapter.this.fireTableRowsUpdated(row, row);
                    if (event.getPath().getLastPathComponent() instanceof TreeTableNode) {
                        int childcount = ((TreeTableNode)event.getPath().getLastPathComponent()).getChildCount();
                        if (childcount > 0) {
                            TreeTableModelAdapter.this.fireTableRowsInserted(row + 1, row + 1 + childcount);
                        }
                    } else {
                        TreeTableModelAdapter.this.fireTableDataChanged();
                    }
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                int row = TreeTableModelAdapter.this.tree.getRowForPath(event.getPath());
                if (row != -1) {
                    TreeTableModelAdapter.this.fireTableRowsUpdated(row, row);
                    if (event.getPath().getLastPathComponent() instanceof TreeTableNode) {
                        int childcount = ((TreeTableNode)event.getPath().getLastPathComponent()).getChildCount();
                        if (childcount > 0) {
                            TreeTableModelAdapter.this.fireTableRowsDeleted(row + 1, row + 1 + childcount);
                        }
                    } else {
                        TreeTableModelAdapter.this.fireTableDataChanged();
                    }
                }
            }
        });
        treeTableModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(final TreeModelEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int row = TreeTableModelAdapter.this.tree.getRowForPath(new TreePath(e.getPath()));
                        if (row != -1 && TreeTableModelAdapter.this.tree.isExpanded(row)) {
                            int[] rows = e.getChildIndices();
                            TreeTableModelAdapter.this.fireTableRowsUpdated(row + 1 + rows[0], row + 1 + rows[rows.length - 1]);
                        }
                    }
                });
            }

            @Override
            public void treeNodesInserted(final TreeModelEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int row = TreeTableModelAdapter.this.tree.getRowForPath(new TreePath(e.getPath()));
                        if (row != -1 && TreeTableModelAdapter.this.tree.isExpanded(row)) {
                            TreeTableModelAdapter.this.fireTableRowsUpdated(row, row);
                            int[] rows = e.getChildIndices();
                            TreeTableModelAdapter.this.fireTableRowsInserted(row + 1 + rows[0], row + 1 + rows[rows.length - 1]);
                        }
                    }
                });
            }

            @Override
            public void treeNodesRemoved(final TreeModelEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int row = TreeTableModelAdapter.this.tree.getRowForPath(new TreePath(e.getPath()));
                        if (row != -1 && TreeTableModelAdapter.this.tree.isExpanded(row)) {
                            TreeTableModelAdapter.this.fireTableRowsUpdated(row, row);
                            int[] rows = e.getChildIndices();
                            TreeTableModelAdapter.this.fireTableRowsDeleted(row + 1 + rows[0], row + 1 + rows[rows.length - 1]);
                        }
                    }
                });
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TreeTableModelAdapter.this.fireTableStructureChanged();
                    }
                });
            }
        });
    }

    @Override
    public int getColumnCount() {
        return this.treeTableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int column) {
        return this.treeTableModel.getColumnName(column);
    }

    public Class getColumnClass(int column) {
        return this.treeTableModel.getColumnClass(column);
    }

    @Override
    public int getRowCount() {
        return this.tree.getRowCount();
    }

    protected Object nodeForRow(int row) {
        TreePath treePath = this.tree.getPathForRow(row);
        return treePath.getLastPathComponent();
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.treeTableModel.getValueAt(this.nodeForRow(row), column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.treeTableModel.isCellEditable(this.nodeForRow(row), column);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        this.treeTableModel.setValueAt(value, this.nodeForRow(row), column);
    }
}

