/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui.jtreetable;

import jadex.commons.gui.jtreetable.AbstractTreeTableModel;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.swing.tree.TreeNode;

public class DynamicTreeTableModel
extends AbstractTreeTableModel {
    private String[] columnNames;
    private String[] methodNames;
    private String[] setterMethodNames;
    private Class[] cTypes;

    public DynamicTreeTableModel(TreeNode root, String[] columnNames, String[] getterMethodNames, String[] setterMethodNames, Class[] cTypes) {
        super(root);
        this.columnNames = columnNames;
        this.methodNames = getterMethodNames;
        this.setterMethodNames = setterMethodNames;
        this.cTypes = cTypes;
    }

    @Override
    public int getChildCount(Object node) {
        return ((TreeNode)node).getChildCount();
    }

    @Override
    public Object getChild(Object node, int i) {
        return ((TreeNode)node).getChildAt(i);
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((TreeNode)node).isLeaf();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        if (this.cTypes == null || column < 0 || column >= this.cTypes.length) {
            return null;
        }
        return this.columnNames[column];
    }

    @Override
    public Class getColumnClass(int column) {
        if (this.cTypes == null || column < 0 || column >= this.cTypes.length) {
            return null;
        }
        return this.cTypes[column];
    }

    @Override
    public Object getValueAt(Object node, int column) {
        try {
            Method method = node.getClass().getMethod(this.methodNames[column], null);
            if (method != null) {
                return method.invoke(node, (Object[])null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        return this.setterMethodNames != null && this.setterMethodNames[column] != null;
    }

    @Override
    public void setValueAt(Object aValue, Object node, int column) {
        boolean found = false;
        try {
            Method[] methods = node.getClass().getMethods();
            for (int counter = methods.length - 1; counter >= 0; --counter) {
                if (!methods[counter].getName().equals(this.setterMethodNames[column]) || methods[counter].getParameterTypes() == null || methods[counter].getParameterTypes().length != 1) continue;
                Class<?> param = methods[counter].getParameterTypes()[0];
                if (!param.isInstance(aValue)) {
                    Constructor<?> cs;
                    aValue = aValue instanceof String && ((String)aValue).length() == 0 ? null : ((cs = param.getConstructor(String.class)) != null ? cs.newInstance(aValue) : null);
                }
                methods[counter].invoke(node, aValue);
                found = true;
                break;
            }
        }
        catch (Exception th) {
            System.out.println("exception: " + th);
        }
        if (found) {
            TreeNode parent = ((TreeNode)node).getParent();
            this.fireTreeNodesChanged(this, this.getPathToRoot(parent), new int[]{this.getIndexOfChild(parent, node)}, new Object[]{node});
        }
    }
}

