/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui.jtreetable;

import jadex.commons.gui.jtreetable.DefaultTreeTableModel;
import jadex.commons.gui.jtreetable.TreeTableNode;
import jadex.commons.gui.jtreetable.TreeTableNodeType;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class DefaultTreeTableNode
extends DefaultMutableTreeNode
implements TreeTableNode {
    protected TreeTableNodeType type;
    protected Map values;
    protected DefaultTreeTableModel model;

    public DefaultTreeTableNode(TreeTableNodeType type, Object object) {
        this(type, object, new HashMap());
        this.setValue(0, object);
    }

    public DefaultTreeTableNode(TreeTableNodeType type, Object object, Map values) {
        super(object);
        this.type = type;
        this.values = values;
    }

    public TreeTableNodeType getType() {
        return this.type;
    }

    public boolean instanceOf(TreeTableNodeType type) {
        boolean ret = false;
        for (TreeTableNodeType mytype = this.type; !ret && mytype != null; mytype = mytype.getSupertype()) {
            ret = mytype.equals(type);
        }
        return ret;
    }

    @Override
    public Object getValue(int column) {
        return this.type.getColumns().length > column && !this.type.isColumnExcluded(column) ? this.values.get(this.type.getColumns()[column]) : "";
    }

    public Map getValues() {
        return this.values;
    }

    public void setValue(int column, Object value) {
        this.values.put(this.type.getColumns()[column], value);
        if (this.getModel() != null && (this.getParent() == null || this.getParent() instanceof DefaultMutableTreeNode)) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.getParent();
            this.getModel().fireTreeNodesChanged(this, parent == null ? new Object[]{} : parent.getPath(), new int[]{parent == null ? 0 : parent.getIndex(this)}, new Object[]{this});
        }
    }

    public void setValues(Map values) {
        this.values = values;
        if (this.getModel() != null && (this.getParent() == null || this.getParent() instanceof DefaultMutableTreeNode)) {
            Object[] objectArray;
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.getParent();
            DefaultTreeTableModel defaultTreeTableModel = this.getModel();
            if (parent == null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this;
            } else {
                objectArray = parent.getPath();
            }
            defaultTreeTableModel.fireTreeNodesChanged(this, objectArray, new int[]{parent == null ? 0 : parent.getIndex(this)}, new Object[]{this});
        }
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        super.insert(child, index);
        if (this.getModel() != null) {
            if (child instanceof DefaultTreeTableNode) {
                ((DefaultTreeTableNode)child).setModel(this.getModel());
            }
            this.getModel().fireTreeNodesInserted(this, this.getPath(), new int[]{index}, new Object[]{child});
        }
    }

    @Override
    public void remove(int index) {
        TreeNode child = this.getChildAt(index);
        if (this.getModel() != null) {
            this.getModel().fireTreeNodesRemoved(this, this.getPath(), new int[]{index}, new Object[]{child});
        }
        super.remove(index);
    }

    public DefaultTreeTableNode getChild(Object obj) {
        DefaultTreeTableNode child = null;
        for (int i = 0; i < this.getChildCount() && child == null; ++i) {
            if (!(this.getChildAt(i) instanceof DefaultTreeTableNode) || (child = (DefaultTreeTableNode)this.getChildAt(i)).getUserObject() != null && child.getUserObject().equals(obj)) continue;
            child = null;
        }
        return child;
    }

    public TreeTableNode[] getChildren() {
        TreeTableNode[] children = new TreeTableNode[this.getChildCount()];
        for (int i = 0; i < children.length; ++i) {
            children[i] = (TreeTableNode)this.getChildAt(i);
        }
        return children;
    }

    protected void setModel(DefaultTreeTableModel model) {
        this.model = model;
    }

    protected DefaultTreeTableModel getModel() {
        if (this.model == null && this.getParent() instanceof DefaultTreeTableNode) {
            this.model = ((DefaultTreeTableNode)this.getParent()).getModel();
        }
        return this.model;
    }

    @Override
    public String toString() {
        return "" + this.getValue(0);
    }
}

