/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui.jtable;

import jadex.commons.gui.jtable.AbstractIndexTableModel;
import jadex.commons.gui.jtable.ISorterFilterTableModel;
import jadex.commons.gui.jtable.SortHeaderRenderer;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class SorterFilterTableModel
extends AbstractIndexTableModel
implements ISorterFilterTableModel {
    public static final int PAUSE_DISPLAYING_OFF = -1;
    protected Vector filter = new Vector();
    protected boolean doFilter = false;
    protected Vector sortColumns = new Vector();
    protected int sortColumn = -1;
    protected int sortDirection = 0;
    protected boolean pauseDisplaying = false;
    protected int pauseRow = -1;

    public SorterFilterTableModel(TableModel delegate) {
        super(delegate);
        this.renewIndex();
    }

    public void renewIndex() {
        this.indexList.clear();
        if (this.pauseRow > this.delegate.getRowCount()) {
            this.pauseRow = this.delegate.getRowCount();
        }
        int rows = this.pauseRow != -1 ? this.pauseRow : this.delegate.getRowCount();
        for (int row = 0; row < rows; ++row) {
            if (!this.isFiltered(this.getRowData(row))) continue;
            this.indexList.add(row);
        }
        if (this.isDoSort()) {
            RowComparator rowComparator = new RowComparator(this.sortColumn, this.sortDirection == 2);
            Collections.sort(this.indexList, rowComparator);
        }
        this.fireTableDataChanged();
    }

    @Override
    public void tableRowsDeleted(int column, int firstRow, int lastRow) {
        for (int row = firstRow; row <= lastRow; ++row) {
            int index = this.indexList.indexOf(row);
            if (index == -1) continue;
            this.indexList.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
    }

    @Override
    public void tableRowsInserted(int column, int firstRow, int lastRow) {
        if (this.isPausedDisplaying()) {
            return;
        }
        for (int row = firstRow; row <= lastRow; ++row) {
            if (!this.isFiltered(this.getRowData(row))) continue;
            int index = this.getRowCount();
            if (this.isDoSort()) {
                RowComparator rowComparator = new RowComparator(this.sortColumn, this.sortDirection == 2);
                int result = Collections.binarySearch(this.indexList, row, rowComparator);
                index = result < 0 ? -1 - result : result;
            }
            this.indexList.add(index, row);
            this.fireTableRowsInserted(index, index);
        }
    }

    @Override
    public void tableRowsUpdated(int column, int firstRow, int lastRow) {
        if (lastRow == Integer.MAX_VALUE) {
            this.renewIndex();
        } else {
            for (int row = firstRow; row <= lastRow; ++row) {
                int index = this.indexList.indexOf(row);
                if (index == -1) continue;
                this.fireTableRowsUpdated(index, index);
            }
        }
    }

    private Vector getRowData(int row) {
        Vector<Object> rowData = new Vector<Object>();
        int columns = this.delegate.getColumnCount();
        for (int column = 0; column < columns; ++column) {
            rowData.add(this.delegate.getValueAt(row, column));
        }
        return rowData;
    }

    private boolean isFiltered(Vector rowData) {
        if (this.filter == null || !this.doFilter) {
            return true;
        }
        boolean[] rowLogic = new boolean[this.filter.size() - 1];
        for (int i = 0; i < this.filter.size() - 1; ++i) {
            Vector rowFilter = (Vector)this.filter.elementAt(i);
            rowLogic[i] = true;
            for (int j = 0; j < rowFilter.size() - 1; ++j) {
                if (rowFilter.elementAt(j) == null || rowData.elementAt(j) == null) continue;
                String cellFilter = rowFilter.elementAt(j).toString().trim();
                String cellData = rowData.elementAt(j).toString().trim();
                if (cellFilter.length() == 0) continue;
                try {
                    if (cellData.matches(cellFilter)) continue;
                    rowLogic[i] = false;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        boolean result = rowLogic.length == 0;
        for (int i = 0; i < rowLogic.length; ++i) {
            result = result || rowLogic[i];
        }
        return result;
    }

    public void addMouseListener(final JTable table) {
        table.getTableHeader().setDefaultRenderer(new SortHeaderRenderer());
        table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getButton() == 1) {
                    int tableColumn = table.columnAtPoint(event.getPoint());
                    Rectangle r = table.getTableHeader().getHeaderRect(tableColumn);
                    r.grow(-3, 0);
                    if (r.contains(event.getPoint())) {
                        int modelColumn = table.convertColumnIndexToModel(tableColumn);
                        SorterFilterTableModel.this.sortDirection = modelColumn == SorterFilterTableModel.this.sortColumn ? ++SorterFilterTableModel.this.sortDirection % 3 : 1;
                        SorterFilterTableModel.this.sortColumn = modelColumn;
                        RowComparator rowComparator = new RowComparator(SorterFilterTableModel.this.sortColumn, SorterFilterTableModel.this.sortDirection == 2);
                        Collections.sort(SorterFilterTableModel.this.indexList, SorterFilterTableModel.this.isDoSort() ? rowComparator : null);
                        SorterFilterTableModel.this.fireTableDataChanged();
                        table.getTableHeader().resizeAndRepaint();
                    }
                }
            }
        });
    }

    @Override
    public int getSortColumn() {
        return this.sortColumn;
    }

    @Override
    public void setSortColumn(int sortColumn) {
        this.sortColumn = sortColumn;
    }

    @Override
    public int getSortDirection() {
        return this.sortDirection;
    }

    @Override
    public void setSortDirection(int sortDirection) {
        this.sortDirection = sortDirection;
    }

    public boolean isDoSort() {
        return this.sortColumn != -1 && this.sortDirection != 0;
    }

    @Override
    public void setFilter(Vector filter) {
        this.filter = filter;
    }

    @Override
    public Vector getFilter() {
        return this.filter;
    }

    @Override
    public boolean isDoFilter() {
        return this.doFilter;
    }

    @Override
    public void setDoFilter(boolean doFilter) {
        this.doFilter = doFilter;
    }

    public boolean isPausedDisplaying() {
        return this.pauseRow != -1;
    }

    public void setPauseDisplaying(boolean pauseDisplaying) {
        this.pauseRow = pauseDisplaying ? this.delegate.getRowCount() : -1;
    }

    private class RowComparator
    implements Comparator {
        private boolean reverse = false;
        private int column;

        public RowComparator(int column, boolean reverse) {
            this.column = column;
            this.reverse = reverse;
        }

        public int compare(Object o1, Object o2) {
            int result = 0;
            int rowA = (Integer)o1;
            int rowB = (Integer)o2;
            Object a = SorterFilterTableModel.this.delegate.getValueAt(rowA, this.column);
            Object b = SorterFilterTableModel.this.delegate.getValueAt(rowB, this.column);
            boolean areTheyCompareable = a instanceof Comparable && b instanceof Comparable && a.getClass() == b.getClass();
            result = areTheyCompareable ? ((Comparable)a).compareTo((Comparable)b) : a.toString().compareTo(b.toString());
            if (result == 0) {
                result = ((Integer)o1).compareTo((Integer)o2);
            }
            return this.reverse ? result * -1 : result;
        }
    }
}

