/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui.jtable;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ResizeableTableHeader
extends JTableHeader
implements TableModelListener {
    protected boolean autoResizingEnabled = false;
    protected boolean includeHeaderWidth = false;

    public ResizeableTableHeader() {
        this(null);
    }

    public ResizeableTableHeader(TableColumnModel cm) {
        super(cm);
        this.addMouseListener(new ResizingMouseAdapter());
    }

    @Override
    public void setTable(JTable table) {
        JTable old = this.table;
        if (table != old) {
            if (old != null && old.getModel() != null) {
                old.getModel().removeTableModelListener(this);
            }
            if (table != null && table.getModel() != null) {
                table.getModel().addTableModelListener(this);
            }
        }
        this.table = table;
        this.firePropertyChange("table", old, table);
    }

    public void setAutoResizingEnabled(boolean autoResizingEnabled) {
        boolean old = this.autoResizingEnabled;
        this.autoResizingEnabled = autoResizingEnabled;
        this.firePropertyChange("autoResizingEnabled", old, autoResizingEnabled);
    }

    public boolean getAutoResizingEnabled() {
        return this.autoResizingEnabled;
    }

    public void setIncludeHeaderWidth(boolean includeHeaderWidth) {
        boolean old = this.includeHeaderWidth;
        this.includeHeaderWidth = includeHeaderWidth;
        this.firePropertyChange("includeHeaderWidth", old, this.autoResizingEnabled);
    }

    public boolean getIncludeHeaderWidth() {
        return this.includeHeaderWidth;
    }

    public void resizeColumn(TableColumn column) {
        if (column != null) {
            this.adjustColumnWidth(column);
        }
    }

    public void resizeAllColumns() {
        for (int col = 0; col < this.table.getColumnCount(); ++col) {
            TableColumn column = this.table.getColumnModel().getColumn(col);
            this.adjustColumnWidth(column);
        }
    }

    public void setColumnWidths(TableColumn column, int preferredWidth, int minWidth, int maxWidth) {
        if (column != null) {
            if (preferredWidth != -1) {
                column.setPreferredWidth(preferredWidth);
            }
            if (minWidth != -1) {
                column.setMinWidth(minWidth);
            }
            if (maxWidth != -1) {
                column.setMaxWidth(maxWidth);
            }
        }
    }

    public void setAllColumnWidths(int preferredWidth, int minWidth, int maxWidth) {
        for (int col = 0; col < this.table.getColumnCount(); ++col) {
            TableColumn column = this.table.getColumnModel().getColumn(col);
            this.setColumnWidths(column, preferredWidth, minWidth, maxWidth);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.getAutoResizingEnabled()) {
            if (e.getType() == -1) {
                this.resizeAllColumns();
            } else {
                for (int col = 0; col < this.table.getColumnCount(); ++col) {
                    TableColumn column = this.table.getColumnModel().getColumn(col);
                    if (!this.canResize(column)) continue;
                    int width = column.getPreferredWidth();
                    for (int row = e.getFirstRow(); row <= e.getLastRow() && row < this.table.getRowCount() && row != -1; ++row) {
                        TableCellRenderer renderer = this.table.getCellRenderer(row, col);
                        Component comp = renderer.getTableCellRendererComponent(this.table, this.table.getValueAt(row, col), false, false, row, col);
                        width = Math.max(width, comp.getPreferredSize().width + this.table.getColumnModel().getColumnMargin());
                    }
                    column.setPreferredWidth(width);
                }
            }
        }
    }

    private void adjustColumnWidth(TableColumn column) {
        int width = 0;
        int col = this.table.convertColumnIndexToView(column.getModelIndex());
        if (this.includeHeaderWidth) {
            TableCellRenderer headerRenderer = column.getHeaderRenderer();
            if (headerRenderer == null) {
                headerRenderer = this.table.getTableHeader().getDefaultRenderer();
            }
            Component headerComp = headerRenderer.getTableCellRendererComponent(this.table, column.getHeaderValue(), false, false, 0, col);
            width = Math.max(width, headerComp.getPreferredSize().width);
        }
        for (int row = 0; row < this.table.getRowCount(); ++row) {
            TableCellRenderer renderer = this.table.getCellRenderer(row, col);
            Component comp = renderer.getTableCellRendererComponent(this.table, this.table.getValueAt(row, col), false, false, row, col);
            width = Math.max(width, comp.getPreferredSize().width);
        }
        column.setPreferredWidth(width += this.table.getColumnModel().getColumnMargin());
    }

    private boolean canResize(TableColumn column) {
        return column != null && this.getResizingAllowed() && column.getResizable();
    }

    private TableColumn getResizingColumn(Point p) {
        return this.getResizingColumn(p, this.columnAtPoint(p));
    }

    private TableColumn getResizingColumn(Point p, int column) {
        int columnIndex;
        if (column == -1) {
            return null;
        }
        Rectangle r = this.getHeaderRect(column);
        r.grow(-3, 0);
        if (r.contains(p)) {
            return null;
        }
        int midPoint = r.x + r.width / 2;
        if (this.getComponentOrientation().isLeftToRight()) {
            columnIndex = p.x < midPoint ? column - 1 : column;
        } else {
            int n = columnIndex = p.x < midPoint ? column : column - 1;
        }
        if (columnIndex == -1) {
            return null;
        }
        return this.getColumnModel().getColumn(columnIndex);
    }

    private class ResizingMouseAdapter
    extends MouseAdapter {
        private ResizingMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            TableColumn resizingColumn;
            if (me.getClickCount() == 2 && me.getButton() == 1 && ResizeableTableHeader.this.canResize(resizingColumn = ResizeableTableHeader.this.getResizingColumn(me.getPoint()))) {
                ResizeableTableHeader.this.adjustColumnWidth(resizingColumn);
            }
        }
    }
}

