/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui.jtable;

import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.util.EventObject;
import java.util.regex.Pattern;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public class PatternEditor
extends DefaultCellEditor {
    Class[] argTypes = new Class[]{String.class};
    Constructor constructor;
    Object value;

    public PatternEditor() {
        super(new JTextField());
    }

    @Override
    public boolean stopCellEditing() {
        String s = (String)super.getCellEditorValue();
        if ("".equals(s)) {
            if (this.constructor.getDeclaringClass() == String.class) {
                this.value = s;
            }
            return super.stopCellEditing();
        }
        try {
            Pattern.compile(s);
        }
        catch (Exception e) {
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
            JOptionPane.showMessageDialog(null, e.getMessage(), "Pattern Syntax Exception", 0);
            return false;
        }
        try {
            this.value = this.constructor.newInstance(s);
        }
        catch (Exception e) {
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
            return false;
        }
        return super.stopCellEditing();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.value = null;
        ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
        try {
            Class<Object> type = table.getColumnClass(column);
            if (type == Object.class) {
                type = String.class;
            }
            this.constructor = type.getConstructor(this.argTypes);
        }
        catch (Exception e) {
            return null;
        }
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return false;
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }
}

