/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui.jtable;

import jadex.commons.SUtil;
import jadex.commons.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class ObjectTableModel
extends AbstractTableModel {
    protected Vector columns;
    protected Vector data = new Vector();
    protected HashMap columnclasses;
    protected HashSet columseditable;

    public ObjectTableModel() {
    }

    public ObjectTableModel(String[] colnames) {
        this.columns = new Vector();
        this.columnclasses = new HashMap();
        this.columseditable = new HashSet();
        for (int i = 0; i < colnames.length; ++i) {
            this.columns.add(colnames[i]);
        }
    }

    public void addRow(Object row, Object object) {
        ArrayList<Object> r = new ArrayList<Object>();
        r.add(row);
        this.insertRow(this.getRowCount(), r, object);
    }

    public void addRow(ArrayList row, Object object) {
        this.insertRow(this.getRowCount(), row, object);
    }

    public void addRow(Object[] row, Object object) {
        this.insertRow(this.getRowCount(), SUtil.arrayToList((Object)row), object);
    }

    public void insertRow(int rowcnt, Object[] row, Object object) {
        this.insertRow(rowcnt, SUtil.arrayToList((Object)row), object);
    }

    public synchronized void insertRow(int rowcnt, List row, Object object) {
        this.data.add(rowcnt, new Tuple((Object)row, object));
        this.fireTableRowsInserted(rowcnt, rowcnt);
    }

    public synchronized void removeRow(Object object) {
        for (int i = 0; i < this.getRowCount() && object != null; ++i) {
            if (!object.equals(((Tuple)this.data.get(i)).get(1))) continue;
            this.data.remove(i);
            this.fireTableRowsDeleted(i, i);
        }
    }

    public synchronized void removeRow(int cnt) {
        this.data.remove(cnt);
        this.fireTableRowsDeleted(cnt, cnt);
    }

    public synchronized void removeAllRows() {
        int size = this.data.size();
        if (size > 0) {
            this.data.clear();
            this.fireTableRowsDeleted(0, size - 1);
        }
    }

    public synchronized void modifyData(Object val, int rowcnt, int columncnt) {
        Tuple tuple = (Tuple)this.data.get(rowcnt);
        List da = (List)tuple.getEntity(0);
        da.remove(columncnt);
        da.add(columncnt, val);
        this.fireTableRowsInserted(rowcnt, rowcnt);
    }

    public synchronized Object getObjectForRow(int rowcnt) {
        return ((Tuple)this.data.get(rowcnt)).get(1);
    }

    @Override
    public String getColumnName(int column) {
        return (String)this.columns.get(column);
    }

    public Class getColumnClass(int idx) {
        Class<Object> clazz = (Class<Object>)this.columnclasses.get(idx);
        if (clazz == null) {
            clazz = Object.class;
        }
        return clazz;
    }

    public void setColumnClass(Class clazz, int idx) {
        this.columnclasses.put(idx, clazz);
    }

    public void setColumnEditable(boolean editable, int col) {
        if (editable) {
            this.columseditable.add(col);
        } else {
            this.columseditable.remove(col);
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.columseditable.contains(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public synchronized Object getValueAt(int row, int column) {
        return ((ArrayList)((Tuple)this.data.get(row)).get(0)).get(column);
    }
}

