/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui.future;

import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.IFutureCommandResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.future.IUndoneResultListener;
import jadex.commons.gui.SGUI;
import java.util.function.Consumer;
import java.util.logging.Logger;

public class SwingResultListener<E>
implements IUndoneResultListener<E>,
IFutureCommandResultListener<E> {
    protected IResultListener<E> listener;
    protected boolean undone;

    public SwingResultListener(Consumer<E> listener) {
        this(listener, null);
    }

    public SwingResultListener(final Consumer<E> listener, final Consumer<Exception> exceptionListener) {
        this((IResultListener<E>)new DefaultResultListener<E>(){

            public void resultAvailable(E result) {
                listener.accept(result);
            }

            public void exceptionOccurred(Exception exception) {
                if (exceptionListener != null) {
                    exceptionListener.accept(exception);
                } else {
                    super.exceptionOccurred(exception);
                }
            }
        });
    }

    public SwingResultListener(IResultListener<E> listener) {
        this.listener = listener;
    }

    public final void resultAvailable(final E result) {
        SGUI.invokeLaterSimBlock(new Runnable(){

            @Override
            public void run() {
                SwingResultListener.this.customResultAvailable(result);
            }
        });
    }

    public final void exceptionOccurred(final Exception exception) {
        SGUI.invokeLaterSimBlock(new Runnable(){

            @Override
            public void run() {
                SwingResultListener.this.customExceptionOccurred(exception);
            }
        });
    }

    public void customResultAvailable(E result) {
        if (this.undone && this.listener instanceof IUndoneResultListener) {
            ((IUndoneResultListener)this.listener).resultAvailableIfUndone(result);
        } else {
            this.listener.resultAvailable(result);
        }
    }

    public void customExceptionOccurred(Exception exception) {
        if (this.undone && this.listener instanceof IUndoneResultListener) {
            ((IUndoneResultListener)this.listener).exceptionOccurredIfUndone(exception);
        } else {
            this.listener.exceptionOccurred(exception);
        }
    }

    public final void commandAvailable(final Object command) {
        SGUI.invokeLaterSimBlock(new Runnable(){

            @Override
            public void run() {
                SwingResultListener.this.customCommandAvailable(command);
            }
        });
    }

    public void customCommandAvailable(Object command) {
        if (this.listener instanceof IFutureCommandResultListener) {
            ((IFutureCommandResultListener)this.listener).commandAvailable(command);
        } else {
            Logger.getLogger("swing-result-listener").fine("Cannot forward command: " + this.listener + " " + command);
        }
    }

    public void resultAvailableIfUndone(E result) {
        this.undone = true;
        this.resultAvailable(result);
    }

    public void exceptionOccurredIfUndone(Exception exception) {
        this.undone = true;
        this.exceptionOccurred(exception);
    }

    public boolean isUndone() {
        return this.undone;
    }
}

