/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui.future;

import jadex.commons.future.IFutureCommandResultListener;
import jadex.commons.future.IIntermediateFutureCommandResultListener;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IUndoneIntermediateResultListener;
import jadex.commons.future.IUndoneResultListener;
import jadex.commons.future.IntermediateDefaultResultListener;
import jadex.commons.gui.SGUI;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.logging.Logger;

public class SwingIntermediateResultListener<E>
implements IIntermediateFutureCommandResultListener<E>,
IUndoneIntermediateResultListener<E> {
    protected IIntermediateResultListener<E> listener;
    protected boolean undone;

    public SwingIntermediateResultListener(Consumer<E> intermediateListener) {
        this(intermediateListener, null);
    }

    public SwingIntermediateResultListener(Consumer<E> ilistener, Consumer<Void> flistener) {
        this(ilistener, flistener, null, null);
    }

    public SwingIntermediateResultListener(final Consumer<E> ilistener, final Consumer<Void> flistener, final Consumer<Exception> elistener, final Consumer<Integer> clistener) {
        this((IIntermediateResultListener<E>)new IntermediateDefaultResultListener<E>(){

            public void intermediateResultAvailable(E result) {
                ilistener.accept(result);
            }

            public void finished() {
                if (flistener != null) {
                    flistener.accept(null);
                }
            }

            public void exceptionOccurred(Exception exception) {
                if (elistener != null) {
                    elistener.accept(exception);
                } else {
                    super.exceptionOccurred(exception);
                }
            }

            public void maxResultCountAvailable(int max) {
                if (clistener != null) {
                    clistener.accept(max);
                }
            }
        });
    }

    public SwingIntermediateResultListener(IIntermediateResultListener<E> listener) {
        this.listener = listener;
    }

    public void resultAvailable(final Collection<E> result) {
        SGUI.invokeLaterSimBlock(new Runnable(){

            @Override
            public void run() {
                SwingIntermediateResultListener.this.customResultAvailable(result);
            }
        });
    }

    public void exceptionOccurred(final Exception exception) {
        SGUI.invokeLaterSimBlock(new Runnable(){

            @Override
            public void run() {
                SwingIntermediateResultListener.this.customExceptionOccurred(exception);
            }
        });
    }

    public void intermediateResultAvailable(final E result) {
        SGUI.invokeLaterSimBlock(new Runnable(){

            @Override
            public void run() {
                SwingIntermediateResultListener.this.customIntermediateResultAvailable(result);
            }
        });
    }

    public void finished() {
        SGUI.invokeLaterSimBlock(new Runnable(){

            @Override
            public void run() {
                SwingIntermediateResultListener.this.customFinished();
            }
        });
    }

    public void maxResultCountAvailable(final int max) {
        SGUI.invokeLaterSimBlock(new Runnable(){

            @Override
            public void run() {
                SwingIntermediateResultListener.this.listener.maxResultCountAvailable(max);
            }
        });
    }

    public void customFinished() {
        if (this.undone && this.listener instanceof IUndoneIntermediateResultListener) {
            ((IUndoneIntermediateResultListener)this.listener).finishedIfUndone();
        } else {
            this.listener.finished();
        }
    }

    public void customResultAvailable(Collection<E> result) {
        if (this.undone && this.listener instanceof IUndoneResultListener) {
            ((IUndoneResultListener)this.listener).resultAvailableIfUndone(result);
        } else {
            this.listener.resultAvailable(result);
        }
    }

    public void customExceptionOccurred(Exception exception) {
        if (this.undone && this.listener instanceof IUndoneResultListener) {
            ((IUndoneResultListener)this.listener).exceptionOccurredIfUndone(exception);
        } else {
            this.listener.exceptionOccurred(exception);
        }
    }

    public void customIntermediateResultAvailable(E result) {
        if (this.undone && this.listener instanceof IUndoneIntermediateResultListener) {
            ((IUndoneIntermediateResultListener)this.listener).intermediateResultAvailableIfUndone(result);
        } else {
            this.listener.intermediateResultAvailable(result);
        }
    }

    public final void commandAvailable(final Object command) {
        SGUI.invokeLaterSimBlock(new Runnable(){

            @Override
            public void run() {
                SwingIntermediateResultListener.this.customCommandAvailable(command);
            }
        });
    }

    public void customCommandAvailable(Object command) {
        if (this.listener instanceof IFutureCommandResultListener) {
            ((IFutureCommandResultListener)this.listener).commandAvailable(command);
        } else {
            Logger.getLogger("swing-result-listener").fine("Cannot forward command: " + this.listener + " " + command);
        }
    }

    public void resultAvailableIfUndone(Collection<E> result) {
        this.undone = true;
        this.resultAvailable(result);
    }

    public void exceptionOccurredIfUndone(Exception exception) {
        this.undone = true;
        this.exceptionOccurred(exception);
    }

    public void intermediateResultAvailableIfUndone(E result) {
        this.undone = true;
        this.intermediateResultAvailable(result);
    }

    public void finishedIfUndone() {
        this.undone = true;
        this.finished();
    }

    public boolean isUndone() {
        return this.undone;
    }
}

