/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui.future;

import jadex.commons.future.Future;
import jadex.commons.future.IIntermediateFutureCommandResultListener;
import jadex.commons.future.IUndoneIntermediateResultListener;
import jadex.commons.gui.SGUI;
import java.util.Collection;

public abstract class SwingIntermediateExceptionDelegationResultListener<E, T>
implements IIntermediateFutureCommandResultListener<E>,
IUndoneIntermediateResultListener<E> {
    protected Future<T> future;
    protected boolean undone;

    public SwingIntermediateExceptionDelegationResultListener(Future<T> future) {
        this.future = future;
    }

    public final void resultAvailable(final Collection<E> result) {
        SGUI.invokeLaterSimBlock(new Runnable(){

            @Override
            public void run() {
                SwingIntermediateExceptionDelegationResultListener.this.customResultAvailable(result);
            }
        });
    }

    public final void exceptionOccurred(final Exception exception) {
        SGUI.invokeLaterSimBlock(new Runnable(){

            @Override
            public void run() {
                SwingIntermediateExceptionDelegationResultListener.this.customExceptionOccurred(exception);
            }
        });
    }

    public final void intermediateResultAvailable(final E result) {
        SGUI.invokeLaterSimBlock(new Runnable(){

            @Override
            public void run() {
                SwingIntermediateExceptionDelegationResultListener.this.customIntermediateResultAvailable(result);
            }
        });
    }

    public final void finished() {
        SGUI.invokeLaterSimBlock(new Runnable(){

            @Override
            public void run() {
                SwingIntermediateExceptionDelegationResultListener.this.customFinished();
            }
        });
    }

    public void maxResultCountAvailable(final int max) {
        SGUI.invokeLaterSimBlock(new Runnable(){

            @Override
            public void run() {
                SwingIntermediateExceptionDelegationResultListener.this.customMaxResultCountAvailable(max);
            }
        });
    }

    public void customMaxResultCountAvailable(int max) {
    }

    public void customResultAvailable(Collection<E> result) {
        for (E e : result) {
            this.customIntermediateResultAvailable(e);
        }
        this.customFinished();
    }

    public abstract void customIntermediateResultAvailable(E var1);

    public void customExceptionOccurred(Exception exception) {
        if (this.undone) {
            this.future.setExceptionIfUndone(exception);
        } else {
            this.future.setException(exception);
        }
    }

    public abstract void customFinished();

    public final void commandAvailable(final Object command) {
        SGUI.invokeLaterSimBlock(new Runnable(){

            @Override
            public void run() {
                SwingIntermediateExceptionDelegationResultListener.this.customCommandAvailable(command);
            }
        });
    }

    public void customCommandAvailable(Object command) {
        this.future.sendForwardCommand(command);
    }

    public void resultAvailableIfUndone(Collection<E> result) {
        this.undone = true;
        this.resultAvailable(result);
    }

    public void exceptionOccurredIfUndone(Exception exception) {
        this.undone = true;
        this.exceptionOccurred(exception);
    }

    public void intermediateResultAvailableIfUndone(E result) {
        this.undone = true;
        this.intermediateResultAvailable(result);
    }

    public void finishedIfUndone() {
        this.undone = true;
        this.finished();
    }

    public boolean isUndone() {
        return this.undone;
    }
}

