/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui.future;

import jadex.commons.future.IIntermediateFutureCommandResultListener;
import jadex.commons.future.IUndoneIntermediateResultListener;
import jadex.commons.future.IntermediateFuture;
import jadex.commons.gui.SGUI;
import java.util.Collection;

public class SwingIntermediateDelegationResultListener<E>
implements IIntermediateFutureCommandResultListener<E>,
IUndoneIntermediateResultListener<E> {
    protected IntermediateFuture<E> future;
    protected boolean undone;

    public SwingIntermediateDelegationResultListener(IntermediateFuture<E> future) {
        this.future = future;
    }

    public final void resultAvailable(final Collection<E> result) {
        SGUI.invokeLaterSimBlock(new Runnable(){

            @Override
            public void run() {
                SwingIntermediateDelegationResultListener.this.customResultAvailable(result);
            }
        });
    }

    public final void exceptionOccurred(final Exception exception) {
        SGUI.invokeLaterSimBlock(new Runnable(){

            @Override
            public void run() {
                SwingIntermediateDelegationResultListener.this.customExceptionOccurred(exception);
            }
        });
    }

    public final void intermediateResultAvailable(final E result) {
        SGUI.invokeLaterSimBlock(new Runnable(){

            @Override
            public void run() {
                SwingIntermediateDelegationResultListener.this.customIntermediateResultAvailable(result);
            }
        });
    }

    public final void finished() {
        SGUI.invokeLaterSimBlock(new Runnable(){

            @Override
            public void run() {
                SwingIntermediateDelegationResultListener.this.customFinished();
            }
        });
    }

    public void maxResultCountAvailable(final int max) {
        SGUI.invokeLaterSimBlock(new Runnable(){

            @Override
            public void run() {
                SwingIntermediateDelegationResultListener.this.future.setMaxResultCount(max);
            }
        });
    }

    public void customFinished() {
        if (this.undone) {
            this.future.setFinishedIfUndone();
        } else {
            this.future.setFinished();
        }
    }

    public void customResultAvailable(Collection<E> result) {
        if (this.undone) {
            this.future.setResultIfUndone(result);
        } else {
            this.future.setResult(result);
        }
    }

    public void customExceptionOccurred(Exception exception) {
        if (this.undone) {
            this.future.setExceptionIfUndone(exception);
        } else {
            this.future.setException(exception);
        }
    }

    public void customIntermediateResultAvailable(E result) {
        if (this.undone) {
            this.future.addIntermediateResultIfUndone(result);
        } else {
            this.future.addIntermediateResult(result);
        }
    }

    public final void commandAvailable(final Object command) {
        SGUI.invokeLaterSimBlock(new Runnable(){

            @Override
            public void run() {
                SwingIntermediateDelegationResultListener.this.customCommandAvailable(command);
            }
        });
    }

    public void customCommandAvailable(Object command) {
        this.future.sendForwardCommand(command);
    }

    public void resultAvailableIfUndone(Collection<E> result) {
        this.undone = true;
        this.resultAvailable(result);
    }

    public void exceptionOccurredIfUndone(Exception exception) {
        this.undone = true;
        this.exceptionOccurred(exception);
    }

    public void intermediateResultAvailableIfUndone(E result) {
        this.undone = true;
        this.intermediateResultAvailable(result);
    }

    public void finishedIfUndone() {
        this.undone = true;
        this.finished();
    }

    public boolean isUndone() {
        return this.undone;
    }
}

