/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui.future;

import jadex.commons.future.Future;
import jadex.commons.future.IFutureCommandResultListener;
import jadex.commons.future.IUndoneResultListener;
import jadex.commons.gui.SGUI;

public abstract class SwingExceptionDelegationResultListener<E, T>
implements IUndoneResultListener<E>,
IFutureCommandResultListener<E> {
    protected Future<T> future;
    protected boolean undone;

    public SwingExceptionDelegationResultListener(Future<T> future) {
        this.future = future;
    }

    public final void resultAvailable(final E result) {
        SGUI.invokeLaterSimBlock(new Runnable(){

            @Override
            public void run() {
                try {
                    SwingExceptionDelegationResultListener.this.customResultAvailable(result);
                }
                catch (Exception e) {
                    SwingExceptionDelegationResultListener.this.future.setExceptionIfUndone(e);
                }
            }
        });
    }

    public final void exceptionOccurred(final Exception exception) {
        SGUI.invokeLaterSimBlock(new Runnable(){

            @Override
            public void run() {
                SwingExceptionDelegationResultListener.this.customExceptionOccurred(exception);
            }
        });
    }

    public abstract void customResultAvailable(E var1) throws Exception;

    public void customExceptionOccurred(Exception exception) {
        if (this.undone) {
            this.future.setExceptionIfUndone(exception);
        } else {
            this.future.setException(exception);
        }
    }

    public final void commandAvailable(final Object command) {
        SGUI.invokeLaterSimBlock(new Runnable(){

            @Override
            public void run() {
                SwingExceptionDelegationResultListener.this.customCommandAvailable(command);
            }
        });
    }

    public void customCommandAvailable(Object command) {
        this.future.sendForwardCommand(command);
    }

    public void resultAvailableIfUndone(E result) {
        this.undone = true;
        this.resultAvailable(result);
    }

    public void exceptionOccurredIfUndone(Exception exception) {
        this.undone = true;
        this.exceptionOccurred(exception);
    }

    public boolean isUndone() {
        return this.undone;
    }
}

