/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui.future;

import jadex.commons.future.Future;
import jadex.commons.future.IFutureCommandResultListener;
import jadex.commons.future.IUndoneResultListener;
import jadex.commons.gui.SGUI;
import java.util.function.Consumer;

public class SwingDelegationResultListener<E>
implements IUndoneResultListener<E>,
IFutureCommandResultListener<E> {
    protected Future<E> future;
    protected boolean undone;
    protected Consumer<E> customResultListener;
    protected Consumer<Exception> customExceptionListener;

    public SwingDelegationResultListener(Future<E> fut, Consumer<E> customResultListener) {
        this(fut, customResultListener, null);
    }

    public SwingDelegationResultListener(Future<E> fut, Consumer<E> customResultListener, Consumer<Exception> customExceptionListener) {
        this(fut);
        this.customResultListener = customResultListener;
        this.customExceptionListener = customExceptionListener;
    }

    public SwingDelegationResultListener(Future<E> future) {
        this.future = future;
    }

    public final void resultAvailable(final E result) {
        SGUI.invokeLaterSimBlock(new Runnable(){

            @Override
            public void run() {
                try {
                    SwingDelegationResultListener.this.customResultAvailable(result);
                }
                catch (Exception e) {
                    SwingDelegationResultListener.this.future.setExceptionIfUndone(e);
                }
            }
        });
    }

    public final void exceptionOccurred(final Exception exception) {
        SGUI.invokeLaterSimBlock(new Runnable(){

            @Override
            public void run() {
                SwingDelegationResultListener.this.customExceptionOccurred(exception);
            }
        });
    }

    public void customResultAvailable(E result) {
        if (this.customResultListener != null) {
            this.customResultListener.accept(result);
        } else if (this.undone) {
            this.future.setResultIfUndone(result);
        } else {
            this.future.setResult(result);
        }
    }

    public void customExceptionOccurred(Exception exception) {
        if (this.customExceptionListener != null) {
            this.customExceptionListener.accept(exception);
        } else if (this.undone) {
            this.future.setExceptionIfUndone(exception);
        } else {
            this.future.setException(exception);
        }
    }

    public final void commandAvailable(final Object command) {
        SGUI.invokeLaterSimBlock(new Runnable(){

            @Override
            public void run() {
                SwingDelegationResultListener.this.customCommandAvailable(command);
            }
        });
    }

    public void customCommandAvailable(Object command) {
        this.future.sendForwardCommand(command);
    }

    public void resultAvailableIfUndone(E result) {
        this.undone = true;
        this.resultAvailable(result);
    }

    public void exceptionOccurredIfUndone(Exception exception) {
        this.undone = true;
        this.exceptionOccurred(exception);
    }

    public boolean isUndone() {
        return this.undone;
    }
}

