/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui.future;

import jadex.commons.SReflect;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFutureCommandResultListener;
import jadex.commons.gui.SGUI;
import java.awt.Component;
import java.util.function.Consumer;
import java.util.logging.Logger;

public class SwingDefaultResultListener<E>
extends DefaultResultListener<E>
implements IFutureCommandResultListener<E> {
    protected Component parent;
    protected Consumer<E> customResultListener;
    protected Consumer<Exception> customExceptionListener;

    public SwingDefaultResultListener(Consumer<E> customResultListener) {
        this(customResultListener, null);
    }

    public SwingDefaultResultListener(Consumer<E> customResultListener, Consumer<Exception> customExceptionListener) {
        this(customResultListener, customExceptionListener, null);
    }

    public SwingDefaultResultListener(Consumer<E> customResultListener, Consumer<Exception> customExceptionListener, Component parent) {
        this(parent);
        this.customResultListener = customResultListener;
        this.customExceptionListener = customExceptionListener;
    }

    protected static void unblock(Future<Void> adblock) {
        if (adblock != null) {
            adblock.setResult(null);
        }
    }

    public SwingDefaultResultListener() {
    }

    public SwingDefaultResultListener(Component parent) {
        this.parent = parent;
    }

    public SwingDefaultResultListener(Logger logger) {
        super(logger);
    }

    public final void resultAvailable(final E result) {
        SGUI.invokeLaterSimBlock(new Runnable(){

            @Override
            public void run() {
                SwingDefaultResultListener.this.customResultAvailable(result);
            }
        });
    }

    public final void exceptionOccurred(final Exception exception) {
        SGUI.invokeLaterSimBlock(new Runnable(){

            @Override
            public void run() {
                SwingDefaultResultListener.this.customExceptionOccurred(exception);
            }
        });
    }

    public void customResultAvailable(E result) {
        if (this.customResultListener != null) {
            this.customResultListener.accept(result);
        }
    }

    public void customExceptionOccurred(Exception exception) {
        if (this.customExceptionListener != null) {
            this.customExceptionListener.accept(exception);
        } else if (this.parent != null) {
            SGUI.showError(this.parent, "Problem Occurred", "A problem occurred while performing the requested action: " + SReflect.getInnerClassName(exception.getClass()) + " " + exception.getMessage(), exception);
        } else {
            super.exceptionOccurred(exception);
        }
    }

    public final void commandAvailable(final Object command) {
        SGUI.invokeLaterSimBlock(new Runnable(){

            @Override
            public void run() {
                SwingDefaultResultListener.this.customCommandAvailable(command);
            }
        });
    }

    public void customCommandAvailable(Object command) {
        Logger.getLogger("swing-result-listener").fine("Cannot forward command: " + this + " " + command);
    }
}

