/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui.autocombo;

import jadex.bridge.ClassInfo;
import jadex.commons.SReflect;
import jadex.commons.gui.autocombo.AbstractFixedAutoComboModel;
import jadex.commons.gui.autocombo.AutoCompleteCombo;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class FixedClassInfoComboModel
extends AbstractFixedAutoComboModel<ClassInfo> {
    public FixedClassInfoComboModel(AutoCompleteCombo combo, int max, List<ClassInfo> allentries) {
        super(combo, max, FixedClassInfoComboModel.sort(allentries));
    }

    public static List<ClassInfo> sort(List<ClassInfo> entries) {
        Collections.sort(entries, new Comparator<ClassInfo>(){

            @Override
            public int compare(ClassInfo c1, ClassInfo c2) {
                return c1.getPrefixNotation().compareTo(c2.getPrefixNotation());
            }
        });
        return entries;
    }

    @Override
    public ClassInfo convertFromString(String val) {
        return new ClassInfo(val);
    }

    @Override
    public String convertToString(ClassInfo val) {
        return val == null || val.getTypeName().length() == 0 ? null : SReflect.getUnqualifiedTypeName((String)val.getGenericTypeName());
    }

    @Override
    public boolean containsVal(ClassInfo val) {
        boolean ret = false;
        if (val == null) {
            ret = true;
        } else {
            String tn = val.getTypeName();
            boolean suffix = tn.indexOf(".") == -1;
            for (ClassInfo item : this.entries) {
                if (!item.equals((Object)val) && (!suffix || !item.getTypeName().endsWith(tn))) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    @Override
    public ClassInfo getModelValue(String val) {
        ClassInfo ret = null;
        boolean suffix = val.indexOf(".") == -1;
        for (ClassInfo item : this.entries) {
            if (!item.getTypeName().equals(val) && !item.getGenericTypeName().equals(val) && (!suffix || !item.getTypeName().endsWith(val))) continue;
            ret = item;
            break;
        }
        return ret;
    }
}

