/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui.autocombo;

import jadex.commons.IFilter;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ISubscriptionIntermediateFuture;
import jadex.commons.future.ITerminationCommand;
import jadex.commons.future.IntermediateEmptyResultListener;
import jadex.commons.future.SubscriptionIntermediateFuture;
import jadex.commons.gui.SDirScan;
import jadex.commons.gui.autocombo.AbstractAutoComboModel;
import jadex.commons.gui.autocombo.AutoCompleteCombo;
import jadex.commons.gui.future.SwingIntermediateResultListener;
import java.io.File;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;

public class ClassComboModel
extends AbstractAutoComboModel<Class<?>> {
    protected boolean inter;
    protected boolean absclasses;
    protected boolean inclasses;
    protected boolean classes;
    protected IFilter<Class<?>> classfilter;
    protected IFilter<String> filefilter;

    public ClassComboModel(AutoCompleteCombo combo, int max) {
        this(combo, max, true, false, false, true, null, null);
    }

    public ClassComboModel(AutoCompleteCombo combo, int max, boolean inter, boolean absclasses, boolean inclasses, boolean classes, IFilter<String> filefilter, IFilter<Class<?>> classfilter) {
        super(combo, max);
        this.inter = inter;
        this.absclasses = absclasses;
        this.inclasses = inclasses;
        this.classes = classes;
        this.filefilter = filefilter;
        this.classfilter = classfilter;
    }

    @Override
    public Class<?> convertFromString(String val) {
        return SReflect.findClass0((String)val, null, (ClassLoader)this.getCombo().getClassLoader());
    }

    @Override
    public String convertToString(Class<?> val) {
        return val == null ? "" : SReflect.getInnerClassName(val);
    }

    @Override
    public ISubscriptionIntermediateFuture<Class<?>> doSetPattern(String pattern) {
        ISubscriptionIntermediateFuture ret;
        assert (SwingUtilities.isEventDispatchThread());
        if (pattern == null || pattern.isEmpty()) {
            if (this.entries.size() > 0) {
                this.getCombo().setSelectedItem(this.getElementAt(0));
            }
            ret = new ISubscriptionIntermediateFuture();
            ret.setResult(null);
        } else {
            this.entries.clear();
            final ISubscriptionIntermediateFuture fret = ret = this.performSearch(pattern, this.inter, this.absclasses, this.classes, this.inclasses, this.max);
            ret.addResultListener((IResultListener)new IntermediateEmptyResultListener<Class<?>>(){

                public void intermediateResultAvailable(Class<?> result) {
                    if (ClassComboModel.this.getCombo().getCurrentSearch() == fret) {
                        ClassComboModel.this.entries.add(result);
                    }
                }

                public void finished() {
                    ClassComboModel.this.getCombo().updatePopup();
                }

                public void resultAvailable(Collection<Class<?>> result) {
                    if (ClassComboModel.this.getCombo().getCurrentSearch() == fret) {
                        for (Class<?> clazz : result) {
                            this.intermediateResultAvailable(clazz);
                        }
                        this.finished();
                    }
                }
            });
        }
        return ret;
    }

    public ISubscriptionIntermediateFuture<Class<?>> performSearch(final String exp, final boolean inter, final boolean abscla, final boolean cla, final boolean incla, final int max) {
        assert (SwingUtilities.isEventDispatchThread());
        final ISubscriptionIntermediateFuture[] fut = new ISubscriptionIntermediateFuture[1];
        final SubscriptionIntermediateFuture ret = new SubscriptionIntermediateFuture(new ITerminationCommand(){

            public void terminated(Exception reason) {
                if (fut[0] != null) {
                    fut[0].terminate();
                }
            }

            public boolean checkTermination(Exception reason) {
                return true;
            }
        });
        if (exp == null || exp.length() == 0) {
            ret.setResultIfUndone(null);
            return ret;
        }
        final Pattern pat = SUtil.createRegexFromGlob((String)(exp + "*"));
        this.getCombo().getThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                IFilter<Object> filefilter = new IFilter<Object>(){

                    public boolean filter(Object obj) {
                        String fn = "";
                        if (obj instanceof File) {
                            File f = (File)obj;
                            fn = f.getName();
                        } else if (obj instanceof JarEntry) {
                            JarEntry je = (JarEntry)obj;
                            fn = je.getName();
                        }
                        if (!incla && fn.indexOf("$") != -1) {
                            return false;
                        }
                        if (ClassComboModel.this.filefilter != null && !ClassComboModel.this.filefilter.filter((Object)fn)) {
                            return false;
                        }
                        StringTokenizer stok = new StringTokenizer(exp, "*?");
                        boolean ret = true;
                        while (ret && stok.hasMoreElements()) {
                            String tst = stok.nextToken();
                            ret = fn.indexOf(tst) != -1;
                        }
                        return ret;
                    }
                };
                IFilter classfilter = new IFilter<Class<?>>(){

                    public boolean filter(Class<?> clazz) {
                        boolean ret;
                        boolean in = clazz.isInterface();
                        boolean abs = Modifier.isAbstract(clazz.getModifiers());
                        boolean bl = ret = in && inter || !in && abs && abscla || !in && !abs && cla;
                        if (ret) {
                            if (ClassComboModel.this.classfilter != null) {
                                ret = ClassComboModel.this.classfilter.filter(clazz);
                            }
                            if (ret) {
                                String clname = SReflect.getInnerClassName(clazz);
                                if (exp.indexOf("*") == -1 && exp.indexOf("?") == -1) {
                                    ret = clname.startsWith(exp);
                                } else {
                                    Matcher m = pat.matcher(clname);
                                    ret = m.matches();
                                }
                            }
                        }
                        return ret;
                    }
                };
                fut[0] = SDirScan.asyncScanForClasses(ClassComboModel.this.getCombo().getClassLoader(), filefilter, classfilter, max, false);
                fut[0].addResultListener(new SwingIntermediateResultListener(new IntermediateEmptyResultListener<Class<?>>(){

                    public void intermediateResultAvailable(Class<?> result) {
                        ret.addIntermediateResultIfUndone(result);
                    }

                    public void finished() {
                        ret.setFinishedIfUndone();
                    }

                    public void resultAvailable(Collection<Class<?>> result) {
                        for (Class<?> clazz : result) {
                            this.intermediateResultAvailable(clazz);
                        }
                        this.finished();
                    }

                    public void exceptionOccurred(Exception exception) {
                        ret.setExceptionIfUndone(exception);
                    }
                }));
            }
        });
        return ret;
    }
}

