/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui.autocombo;

import jadex.commons.SUtil;
import jadex.commons.concurrent.IThreadPool;
import jadex.commons.concurrent.ThreadPool;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ISubscriptionIntermediateFuture;
import jadex.commons.gui.autocombo.AbstractAutoComboModel;
import jadex.commons.gui.autocombo.StringComboModel;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.Timer;
import javax.swing.plaf.metal.MetalComboBoxEditor;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class AutoCompleteCombo<T>
extends JComboBox {
    protected ClassLoader cl;
    protected IThreadPool tp;
    protected String lastpattern;
    protected ISubscriptionIntermediateFuture<T> current;
    protected boolean updating;

    public AutoCompleteCombo(ThreadPool tp, ClassLoader cl) {
        this.tp = tp == null ? new ThreadPool() : tp;
        this.cl = cl == null ? AutoCompleteCombo.class.getClassLoader() : cl;
        this.setEditable(true);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("JComboBox.isTableCellEditor".equals(evt.getPropertyName()) && Boolean.TRUE.equals(evt.getNewValue())) {
                    AutoCompleteCombo.this.putClientProperty("JComboBox.isTableCellEditor", Boolean.FALSE);
                }
            }
        });
        this.setEditor(new MetalComboBoxEditor(){
            Object val;

            @Override
            public void setItem(Object obj) {
                if (SUtil.equals((Object)this.val, (Object)obj) || obj == null) {
                    return;
                }
                String text = AutoCompleteCombo.this.getAutoModel().convertToString(obj);
                if (text != null && !text.equals(this.editor.getText())) {
                    this.val = obj;
                    if (text.length() > 0) {
                        this.editor.setText(text);
                    }
                }
            }

            @Override
            public Object getItem() {
                return AutoCompleteCombo.this.getAutoModel().convertFromString(this.editor.getText());
            }
        });
    }

    public JTextComponent getEditorComponent() {
        JTextComponent comp = (JTextComponent)this.getEditor().getEditorComponent();
        return comp;
    }

    @Override
    public void setEditor(ComboBoxEditor anEditor) {
        super.setEditor(anEditor);
        JTextComponent comp = (JTextComponent)this.getEditor().getEditorComponent();
        if (comp.getDocument() instanceof AutoCompleteDocument) {
            AutoCompleteDocument doc = (AutoCompleteDocument)comp.getDocument();
            doc.dispose();
        }
        comp.setDocument(new AutoCompleteDocument());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public boolean isUpdating() {
        return this.updating;
    }

    public AbstractAutoComboModel<T> getAutoModel() {
        return (AbstractAutoComboModel)this.getModel();
    }

    public String getText() {
        return this.getEditor().getItem() != null ? this.getEditor().getItem().toString() : "";
    }

    private ISubscriptionIntermediateFuture<T> setPattern(String pattern) {
        if (pattern != null && pattern.trim().isEmpty()) {
            pattern = null;
        }
        this.lastpattern = pattern;
        if (this.current != null) {
            this.current.terminate();
        }
        ISubscriptionIntermediateFuture<T> ret = this.getAutoModel().setPattern(pattern);
        this.current = ret;
        return ret;
    }

    public ISubscriptionIntermediateFuture<T> getCurrentSearch() {
        return this.current;
    }

    private void clearSelection() {
        int pos = this.getEditorComponent().getCaretPosition();
        int i = this.getText().length();
        this.getEditorComponent().setSelectionStart(i);
        this.getEditorComponent().setSelectionEnd(i);
        this.getEditorComponent().setCaretPosition(pos);
    }

    protected IThreadPool getThreadPool() {
        return this.tp;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public void updatePopup() {
        try {
            this.hidePopup();
            this.showPopup();
            this.clearSelection();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                frame.setDefaultCloseOperation(3);
                frame.setLayout(new GridLayout(2, 1));
                List vals = SUtil.createArrayList((Object[])new String[]{"a", "aa", "aaa", "aab", "b", "bb", "abc"});
                AutoCompleteCombo combo2 = new AutoCompleteCombo(null, null);
                StringComboModel model2 = new StringComboModel(combo2, 20, vals);
                combo2.setModel(model2);
                frame.add(combo2);
                frame.pack();
                frame.setSize(500, frame.getHeight());
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
    }

    protected class AutoCompleteDocument
    extends PlainDocument {
        protected boolean arrowkey = false;
        protected Timer t;

        public AutoCompleteDocument() {
            AutoCompleteCombo.this.getEditorComponent().addKeyListener(new KeyAdapter(){
                protected boolean dirty = false;
                {
                    AutoCompleteDocument.this.t = new Timer(1000, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (dirty) {
                                dirty = false;
                            } else {
                                AutoCompleteDocument.this.t.stop();
                                AutoCompleteDocument.this.updateModel();
                            }
                        }
                    });
                }

                @Override
                public void keyTyped(KeyEvent e) {
                    int key = e.getKeyCode();
                    if (!AutoCompleteDocument.this.t.isRunning() && key == 10) {
                        AutoCompleteDocument.this.t.start();
                    } else {
                        this.dirty = true;
                    }
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    int key = e.getKeyCode();
                    if (key == 10) {
                        Object obj;
                        String text = AutoCompleteCombo.this.getEditorComponent().getText();
                        if (!AutoCompleteCombo.this.getAutoModel().contains(text)) {
                            AutoCompleteCombo.this.getAutoModel().addToTop(text);
                        } else if (AutoCompleteCombo.this.getSelectedItem() == null && (obj = AutoCompleteCombo.this.getAutoModel().getModelValue(text)) != null) {
                            AutoCompleteCombo.this.getAutoModel().setSelectedItem(obj);
                        }
                        if (AutoCompleteDocument.this.t.isRunning()) {
                            AutoCompleteDocument.this.t.stop();
                        }
                    } else if (key == 38 || key == 40) {
                        AutoCompleteDocument.this.arrowkey = true;
                        if (AutoCompleteDocument.this.t.isRunning()) {
                            AutoCompleteDocument.this.t.stop();
                        }
                    }
                }
            });
        }

        public void dispose() {
            if (this.t != null) {
                this.t.stop();
            }
        }

        protected void updateModel() {
            AutoCompleteCombo.this.updating = true;
            try {
                String text = this.getText(0, this.getLength());
                AutoCompleteCombo.this.setPattern(text).addResultListener(new IResultListener<Collection<T>>(){

                    public void resultAvailable(Collection<T> result) {
                        AutoCompleteCombo.this.clearSelection();
                        AutoCompleteCombo.this.updatePopup();
                        JTextComponent comp = (JTextComponent)AutoCompleteCombo.this.getEditor().getEditorComponent();
                        comp.setCaretPosition(AutoCompleteDocument.this.getLength());
                        AutoCompleteCombo.this.updating = false;
                    }

                    public void exceptionOccurred(Exception exception) {
                        AutoCompleteCombo.this.updating = false;
                    }
                });
            }
            catch (Exception e) {
                AutoCompleteCombo.this.updating = false;
            }
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            if (AutoCompleteCombo.this.current != null && !AutoCompleteCombo.this.current.isDone()) {
                return;
            }
            String beftext = this.getText(0, this.getLength());
            super.remove(offs, len);
            String text = this.getText(0, this.getLength());
            if (this.arrowkey) {
                this.arrowkey = false;
            } else if (!text.equals(beftext)) {
                this.updateModel();
            }
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (AutoCompleteCombo.this.current != null && !AutoCompleteCombo.this.current.isDone()) {
                return;
            }
            String beftext = this.getText(0, this.getLength());
            super.insertString(offs, str, a);
            String text = this.getText(0, this.getLength());
            if (this.arrowkey) {
                this.arrowkey = false;
            } else if (!text.equals(beftext)) {
                this.updateModel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (text == null || text.length() == 0) {
                return;
            }
            this.writeLock();
            try {
                boolean ark = this.arrowkey;
                if (length > 0) {
                    this.remove(offset, length);
                }
                this.arrowkey = ark;
                if (text != null && text.length() > 0) {
                    this.insertString(offset, text, attrs);
                }
            }
            finally {
                this.writeUnlock();
            }
        }
    }
}

