/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui.autocombo;

import jadex.commons.SUtil;
import jadex.commons.future.ISubscriptionIntermediateFuture;
import jadex.commons.future.SubscriptionIntermediateFuture;
import jadex.commons.gui.autocombo.AbstractAutoComboModel;
import jadex.commons.gui.autocombo.AutoCompleteCombo;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;

public abstract class AbstractFixedAutoComboModel<T>
extends AbstractAutoComboModel<T> {
    protected List<T> allentries;

    public AbstractFixedAutoComboModel(AutoCompleteCombo combo, int max, List<T> allentries) {
        super(combo, max);
        this.allentries = allentries;
        this.copyEntries();
    }

    protected void copyEntries() {
        int size1 = this.entries.size();
        this.entries.clear();
        for (int i = 0; i < this.allentries.size() && (this.max == -1 || i < this.max); ++i) {
            this.entries.add(this.allentries.get(i));
        }
        int size2 = this.entries.size();
        this.fireChangeEvents(size1, size2);
    }

    @Override
    public ISubscriptionIntermediateFuture<T> doSetPattern(String pattern) {
        assert (SwingUtilities.isEventDispatchThread());
        if (pattern == null && this.entries.size() == 0) {
            this.copyEntries();
        } else {
            int size1 = this.entries.size();
            this.entries.clear();
            Pattern pat = SUtil.createRegexFromGlob((String)(pattern + "*"));
            for (T tst : this.allentries) {
                String str = this.convertToString(tst);
                Matcher m = pat.matcher(str);
                if (!m.matches()) continue;
                this.entries.add(tst);
            }
            int size2 = this.entries.size();
            this.fireContentsChanged(this, 0, size2);
            this.getCombo().updatePopup();
        }
        SubscriptionIntermediateFuture ret = new SubscriptionIntermediateFuture();
        ret.setResult(null);
        return ret;
    }
}

