/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui.autocombo;

import jadex.commons.future.IResultListener;
import jadex.commons.future.ISubscriptionIntermediateFuture;
import jadex.commons.gui.autocombo.AutoCompleteCombo;
import jadex.commons.gui.future.SwingResultListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public abstract class AbstractAutoComboModel<T>
extends AbstractListModel
implements ComboBoxModel {
    protected T selected;
    protected int max = 20;
    protected List<T> entries;
    protected AutoCompleteCombo<T> combo;

    public AbstractAutoComboModel(AutoCompleteCombo<T> combo, int max) {
        this.combo = combo;
        this.max = max;
        this.entries = new ArrayList<T>();
    }

    public abstract T convertFromString(String var1);

    public abstract String convertToString(T var1);

    public void addToTop(String val) {
        this.addValToTop(this.convertFromString(val));
    }

    public boolean contains(String val) {
        return this.containsVal(this.convertFromString(val));
    }

    public void addValToTop(T val) {
        if (val == null || this.entries.contains(val)) {
            return;
        }
        if (this.entries.size() == 0) {
            this.entries.add(val);
        } else {
            this.entries.add(0, val);
        }
        while (this.max != -1 && this.entries.size() > this.max) {
            int index = this.entries.size() - 1;
            this.entries.remove(index);
        }
        this.fireContentsChanged(this, 0, this.entries.size() - 1);
        this.setSelectedItem(val);
    }

    @Override
    public Object getSelectedItem() {
        return this.selected;
    }

    @Override
    public void setSelectedItem(Object obj) {
        if (this.selected != null && !this.selected.equals(obj) || this.selected == null && obj != null) {
            this.selected = obj;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    public void setSelectedItemQuiet(Object obj) {
        System.out.println("sel quiet is: " + obj);
        this.selected = obj;
    }

    @Override
    public int getSize() {
        return this.entries.size();
    }

    @Override
    public T getElementAt(int index) {
        return this.entries.get(index);
    }

    public boolean containsVal(T val) {
        if (val == null) {
            return true;
        }
        for (T item : this.entries) {
            if (!item.equals(val)) continue;
            return true;
        }
        return false;
    }

    public AutoCompleteCombo<T> getCombo() {
        return this.combo;
    }

    public ISubscriptionIntermediateFuture<T> setPattern(String pattern) {
        final int size1 = this.getSize();
        ISubscriptionIntermediateFuture<T> ret = this.doSetPattern(pattern);
        ret.addResultListener(new SwingResultListener(new IResultListener<Collection<T>>(){

            public void resultAvailable(Collection<T> result) {
                int size2 = AbstractAutoComboModel.this.getSize();
                AbstractAutoComboModel.this.fireChangeEvents(size1, size2);
            }

            public void exceptionOccurred(Exception exception) {
            }
        }));
        return ret;
    }

    public abstract ISubscriptionIntermediateFuture<T> doSetPattern(String var1);

    public T getModelValue(String text) {
        T ret = null;
        T o = this.convertFromString(text);
        for (T tmp : this.entries) {
            if (!tmp.equals(o)) continue;
            ret = tmp;
        }
        return ret;
    }

    protected void fireChangeEvents(int size1, int size2) {
        this.fireContentsChanged(this, 0, size2 - 1);
        if (size1 < size2) {
            this.fireIntervalAdded(this, size1, size2 - 1);
            this.fireContentsChanged(this, 0, size1 - 1);
        } else if (size1 > size2) {
            this.fireIntervalRemoved(this, size2, size1 - 1);
            this.fireContentsChanged(this, 0, size2 - 1);
        }
    }
}

