/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui;

import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public class TreeExpansionHandler
implements TreeExpansionListener,
TreeModelListener {
    protected JTree tree;
    protected Set expanded;

    public TreeExpansionHandler(JTree tree) {
        this.tree = tree;
        this.expanded = new HashSet();
        tree.addTreeExpansionListener(this);
        tree.getModel().addTreeModelListener(this);
        ArrayList<TreeExpansionHandler> tehs = (ArrayList<TreeExpansionHandler>)tree.getClientProperty(TreeExpansionHandler.class);
        if (tehs == null) {
            tehs = new ArrayList<TreeExpansionHandler>();
            tree.putClientProperty(TreeExpansionHandler.class, tehs);
        }
        tehs.add(this);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        this.expanded.add(event.getPath().getLastPathComponent());
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        this.expanded.remove(event.getPath().getLastPathComponent());
    }

    @Override
    public void treeNodesChanged(TreeModelEvent event) {
    }

    @Override
    public void treeNodesInserted(TreeModelEvent event) {
        this.handlePath(event.getTreePath());
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent event) {
        Object[] children = event.getChildren();
        for (int i = 0; i < children.length; ++i) {
            this.expanded.remove(children[i]);
        }
    }

    @Override
    public void treeStructureChanged(TreeModelEvent event) {
        this.handleTreeStructureChanged(event, event.getTreePath(), Math.max(this.tree.getRowForPath(event.getTreePath()), 0));
    }

    public void handleTreeStructureChanged(final TreeModelEvent event, final TreePath root, final int i) {
        TreePath path = this.tree.getPathForRow(i);
        if (path != null && root.isDescendant(path)) {
            this.handlePath(path).addResultListener(new IResultListener(){

                public void resultAvailable(Object result) {
                    TreeExpansionHandler.this.handleTreeStructureChanged(event, root, i + 1);
                }

                public void exceptionOccurred(Exception exception) {
                    exception.printStackTrace();
                }
            });
        }
    }

    protected IFuture handlePath(final TreePath path) {
        final Future ret = new Future();
        if (this.expanded.contains(path.getLastPathComponent())) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeExpansionHandler.this.tree.expandPath(path);
                    ret.setResult(null);
                }
            });
        } else {
            ret.setResult(null);
        }
        return ret;
    }

    public boolean isExpanded(TreePath path) {
        return this.expanded != null && this.expanded.contains(path.getLastPathComponent());
    }

    public static boolean isTreeExpanded(JTree tree, TreePath path) {
        boolean ret = tree.isExpanded(path);
        if (!ret) {
            List tehs = (List)tree.getClientProperty(TreeExpansionHandler.class);
            for (int i = 0; !ret && tehs != null && i < tehs.size(); ++i) {
                TreeExpansionHandler teh = (TreeExpansionHandler)tehs.get(i);
                ret = teh.isExpanded(path);
            }
        }
        return ret;
    }
}

