/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui;

import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;

public class TreeCombo
extends JComboBox {
    static final int OFFSET = 16;
    static Border emptyBorder = new EmptyBorder(0, 0, 0, 0);

    public TreeCombo(JTree tree) {
        this.setModel(new TreeToListModel(tree));
        this.setRenderer(new ListEntryRenderer(tree));
    }

    class ListEntryRenderer
    extends JLabel
    implements ListCellRenderer {
        Icon leafIcon = (Icon)UIManager.get("Tree.expandedIcon");
        Icon nodeIcon = (Icon)UIManager.get("Tree.collapsedIcon");
        JTree tree;

        public ListEntryRenderer(JTree tree) {
            this.setOpaque(true);
            this.tree = tree;
        }

        public Component getListCellRendererComponent(JList listbox, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JComponent ret;
            ListEntry listEntry = (ListEntry)value;
            if (listEntry != null) {
                ret = (JComponent)this.tree.getCellRenderer().getTreeCellRendererComponent(this.tree, listEntry.object(), isSelected, true, !listEntry.isNode(), index, cellHasFocus);
                Border border = index != -1 ? new EmptyBorder(0, 16 * listEntry.level(), 0, 0) : emptyBorder;
                ret.setBorder(border);
            } else {
                this.setText("");
                ret = this;
            }
            return ret;
        }
    }

    class ListEntry {
        Object object;
        int level;
        boolean isNode;

        public ListEntry(Object anObject, int aLevel, boolean isNode) {
            this.object = anObject;
            this.level = aLevel;
            this.isNode = isNode;
        }

        public Object object() {
            return this.object;
        }

        public int level() {
            return this.level;
        }

        public boolean isNode() {
            return this.isNode;
        }
    }

    class TreeToListModel
    extends AbstractListModel
    implements ComboBoxModel,
    TreeModelListener {
        TreeModel source;
        boolean invalid = true;
        Object currentValue;
        Vector cache = new Vector();

        public TreeToListModel(JTree tree) {
            this.source = tree.getModel();
            this.source.addTreeModelListener(this);
            TreeCombo.this.setRenderer(new ListEntryRenderer(tree));
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (this.currentValue != null && !this.currentValue.equals(anObject) || this.currentValue == null && anObject != null) {
                this.currentValue = anObject;
                Enumeration en = this.cache.elements();
                while (en.hasMoreElements()) {
                    ListEntry le = (ListEntry)en.nextElement();
                    if (!le.object().equals(anObject)) continue;
                    this.currentValue = le;
                    break;
                }
            }
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.currentValue;
        }

        @Override
        public int getSize() {
            this.validate();
            return this.cache.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.cache.elementAt(index);
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            this.invalid = true;
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            this.invalid = true;
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            this.invalid = true;
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            this.invalid = true;
        }

        void validate() {
            if (this.invalid) {
                this.cache = new Vector();
                this.cacheTree(this.source.getRoot(), 0);
                if (this.cache.size() > 0) {
                    this.currentValue = this.cache.elementAt(0);
                }
                this.invalid = false;
                this.fireContentsChanged(this, 0, 0);
            }
        }

        void cacheTree(Object anObject, int level) {
            if (this.source.isLeaf(anObject)) {
                this.addListEntry(anObject, level, false);
            } else {
                int c = this.source.getChildCount(anObject);
                this.addListEntry(anObject, level, true);
                ++level;
                for (int i = 0; i < c; ++i) {
                    Object child = this.source.getChild(anObject, i);
                    this.cacheTree(child, level);
                }
                --level;
            }
        }

        void addListEntry(Object anObject, int level, boolean isNode) {
            this.cache.addElement(new ListEntry(anObject, level, isNode));
        }
    }
}

