/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui;

import jadex.bridge.service.types.simulation.SSimulation;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.commons.future.Future;
import jadex.commons.gui.JCopyPasteContextMenu;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class SGUI {
    public static final String AUTO_ADJUST = "auto-adjust";
    protected static final Set<String> BROKEN_UI_IDS = new HashSet<String>();

    public static JMenuBar createMenuBar(Action[] actions) {
        JMenuBar menubar = new JMenuBar();
        JMenu menu = new JMenu("Actions");
        menubar.add(menu);
        for (int i = 0; i < actions.length; ++i) {
            if (actions[i] == null) {
                menu.addSeparator();
                continue;
            }
            menu.add(new JMenuItem(actions[i]));
        }
        return menubar;
    }

    public static JToolBar createToolBar(String name, Action[] actions) {
        JToolBar toolbar = new JToolBar(name);
        toolbar.addSeparator();
        for (int i = 0; i < actions.length; ++i) {
            if (actions[i] == null) {
                toolbar.addSeparator();
                continue;
            }
            JButton button = new JButton(actions[i]);
            button.setToolTipText((String)actions[i].getValue("Name"));
            button.setText("");
            button.setActionCommand((String)actions[i].getValue("Name"));
            button.setRequestFocusEnabled(false);
            button.setMargin(new Insets(1, 1, 1, 1));
            toolbar.add(button);
        }
        return toolbar;
    }

    public static Action createAction(String name, Icon icon, final ActionListener listener) {
        return new AbstractAction(name, icon){

            @Override
            public void actionPerformed(ActionEvent ae) {
                listener.actionPerformed(ae);
            }
        };
    }

    public static boolean createDialog(String title, JComponent content, JComponent comp) {
        return SGUI.createDialog(title, content, comp, false);
    }

    public static boolean createDialog(String title, JComponent content, JComponent comp, boolean info) {
        final JDialog dia = new JDialog((Frame)null, title, true);
        JButton bok = new JButton("OK");
        JPanel ps = new JPanel(new GridBagLayout());
        ps.add((Component)bok, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 14, 3, new Insets(2, 2, 2, 2), 0, 0));
        final boolean[] ok = new boolean[1];
        bok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ok[0] = true;
                dia.dispose();
            }
        });
        if (!info) {
            JButton bcancel = new JButton("Cancel");
            bok.setMinimumSize(bcancel.getMinimumSize());
            bok.setPreferredSize(bcancel.getPreferredSize());
            ps.add((Component)bcancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 14, 1, new Insets(2, 2, 2, 2), 0, 0));
            bcancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dia.dispose();
                }
            });
        }
        dia.getContentPane().add((Component)content, "Center");
        dia.getContentPane().add((Component)ps, "South");
        dia.pack();
        dia.setLocation(SGUI.calculateMiddlePosition(comp != null ? SGUI.getWindowParent(comp) : null, dia));
        dia.setVisible(true);
        return ok[0];
    }

    public static Object makeIcon(final Class baseclass, final String imgloc) {
        return new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                URL url = baseclass.getResource(imgloc);
                if (url == null) {
                    throw new RuntimeException("Cannot load image: " + imgloc);
                }
                return new ImageIcon(url);
            }
        };
    }

    public static void renderObject(Graphics g, Component comp, double cellw, double cellh, int x, int y, int gridwidth) {
        Rectangle bounds = new Rectangle((int)(cellw * (double)x) + gridwidth, (int)(cellh * (double)y) + gridwidth, (int)(cellw * (double)(x + 1)) - (int)(cellw * (double)x) - gridwidth * 2, (int)(cellh * (double)(y + 1)) - (int)(cellh * (double)y) - gridwidth * 2);
        comp.setBounds(bounds);
        g.translate(bounds.x, bounds.y);
        comp.paint(g);
        g.translate(-bounds.x, -bounds.y);
    }

    public static Point calculateMiddlePosition(Window win) {
        return SGUI.calculateMiddlePosition(null, win);
    }

    public static Point calculateMiddlePosition(Window outer, Window win) {
        int ry;
        int rx;
        if (outer != null && outer.isVisible()) {
            Point p = outer.getLocationOnScreen();
            rx = (int)(p.getX() + (double)(outer.getWidth() / 2));
            ry = (int)(p.getY() + (double)(outer.getHeight() / 2));
        } else {
            Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
            rx = (int)size.getWidth() / 2;
            ry = (int)size.getHeight() / 2;
        }
        int x = rx - win.getWidth() / 2;
        int y = ry - win.getHeight() / 2;
        return new Point(x, y);
    }

    public static Window getWindowParent(Component comp) {
        while (comp != null && !(comp instanceof Window)) {
            comp = comp.getParent();
        }
        return (Window)comp;
    }

    public static void showMessageDialog(Component parent, Object message, String title, int msgtype) {
        JOptionPane pane = new JOptionPane(message, msgtype);
        final JDialog dialog = pane.createDialog(parent, title);
        dialog.setModal(false);
        pane.selectInitialValue();
        dialog.setVisible(true);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                dialog.removeWindowListener(this);
                dialog.dispose();
            }
        });
    }

    public static void showError(Component parent, String errortitle, String errormessage, final Exception exception) {
        String exmsg;
        String string = exmsg = exception == null ? null : exception.getMessage();
        Object text = errormessage == null && exmsg == null ? errortitle : (errormessage != null && exmsg == null ? errormessage : (errormessage == null && exmsg != null ? exmsg : errormessage + "\n" + exmsg));
        Object message = SUtil.wrapText((String)text);
        if (exception != null) {
            final JPanel panel = new JPanel(new BorderLayout());
            final JButton details = new JButton("Show Details"){

                @Override
                public Insets getInsets() {
                    return new Insets(1, 1, 1, 1);
                }
            };
            details.addActionListener(new ActionListener(){
                JComponent area = null;
                boolean shown = false;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (this.shown) {
                        panel.remove(this.area);
                        details.setText("Show Details");
                    } else {
                        if (this.area == null) {
                            StringWriter sw = new StringWriter();
                            exception.printStackTrace(new PrintWriter(sw));
                            this.area = new JScrollPane(new JTextArea(sw.toString(), 10, 40));
                        }
                        panel.add((Component)this.area, "Center");
                        details.setText("Hide Details");
                    }
                    SGUI.getWindowParent(panel).pack();
                    this.shown = !this.shown;
                }
            });
            JPanel but = new JPanel(new FlowLayout(2));
            but.add(details);
            JTextArea msg = new JTextArea(message.toString());
            msg.setEditable(false);
            msg.setDropTarget(null);
            msg.setCursor(null);
            msg.setOpaque(false);
            panel.add((Component)msg, "North");
            panel.add((Component)but, "South");
            message = panel;
            panel.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    Dialog dialog;
                    Window window = SwingUtilities.getWindowAncestor(panel);
                    if (window instanceof Dialog && !(dialog = (Dialog)window).isResizable()) {
                        dialog.setResizable(true);
                    }
                }
            });
        }
        JOptionPane.showMessageDialog(parent, message, errortitle, 0);
    }

    public static void adjustComponentSizes(Component[] components) {
        JComponent[] jcomponents = new JComponent[components.length];
        System.arraycopy(components, 0, jcomponents, 0, components.length);
        SGUI.adjustComponentSizes(jcomponents);
    }

    public static void adjustComponentSizes(JComponent[] components) {
        int minimumwidth = 0;
        int minimumheight = 0;
        int maximumwidth = 0;
        int maximumheight = 0;
        int preferredwidth = 0;
        int preferredheight = 0;
        for (int i = 0; i < components.length; ++i) {
            Dimension minimum = components[i].getMinimumSize();
            Dimension maximum = components[i].getMaximumSize();
            Dimension preferred = components[i].getPreferredSize();
            minimumwidth = Math.max(minimumwidth, minimum.width);
            minimumheight = Math.max(minimumheight, minimum.height);
            maximumwidth = Math.max(maximumwidth, maximum.width);
            maximumheight = Math.max(maximumheight, maximum.height);
            preferredwidth = Math.max(preferredwidth, preferred.width);
            preferredheight = Math.max(preferredheight, preferred.height);
        }
        Dimension minimum = new Dimension(minimumwidth, minimumheight);
        Dimension maximum = new Dimension(maximumwidth, maximumheight);
        Dimension preferred = new Dimension(preferredwidth, preferredheight);
        for (int i = 0; i < components.length; ++i) {
            components[i].setMinimumSize(minimum);
            components[i].setMaximumSize(maximum);
            components[i].setPreferredSize(preferred);
        }
    }

    public static void adjustComponentHorizontalSizes(JComponent[] components) {
        Dimension preferred;
        Dimension maximum;
        Dimension minimum;
        int i;
        int minimumwidth = 0;
        int maximumwidth = 0;
        int preferredwidth = 0;
        for (i = 0; i < components.length; ++i) {
            minimum = components[i].getMinimumSize();
            maximum = components[i].getMaximumSize();
            preferred = components[i].getPreferredSize();
            minimumwidth = Math.max(minimumwidth, minimum.width);
            maximumwidth = Math.max(maximumwidth, maximum.width);
            preferredwidth = Math.max(preferredwidth, preferred.width);
        }
        for (i = 0; i < components.length; ++i) {
            minimum = components[i].getMinimumSize();
            maximum = components[i].getMaximumSize();
            preferred = components[i].getPreferredSize();
            minimum = new Dimension(minimumwidth, minimum.height);
            maximum = new Dimension(maximumwidth, maximum.height);
            preferred = new Dimension(preferredwidth, preferred.height);
            components[i].setMinimumSize(minimum);
            components[i].setMaximumSize(maximum);
            components[i].setPreferredSize(preferred);
        }
    }

    public static void adjustComponentVerticalSizes(JComponent[] components) {
        Dimension preferred;
        Dimension maximum;
        Dimension minimum;
        int i;
        int minimumheight = 0;
        int maximumheight = 0;
        int preferredheight = 0;
        for (i = 0; i < components.length; ++i) {
            minimum = components[i].getMinimumSize();
            maximum = components[i].getMaximumSize();
            preferred = components[i].getPreferredSize();
            minimumheight = Math.max(minimumheight, minimum.height);
            maximumheight = Math.max(maximumheight, maximum.height);
            preferredheight = Math.max(preferredheight, preferred.height);
        }
        for (i = 0; i < components.length; ++i) {
            minimum = components[i].getMinimumSize();
            maximum = components[i].getMaximumSize();
            preferred = components[i].getPreferredSize();
            minimum = new Dimension(minimum.width, minimumheight);
            maximum = new Dimension(maximum.width, maximumheight);
            preferred = new Dimension(preferred.width, preferredheight);
            components[i].setMinimumSize(minimum);
            components[i].setMaximumSize(maximum);
            components[i].setPreferredSize(preferred);
        }
    }

    public static void adjustComponentSizes(Container parent) {
        LinkedList<Component> components = new LinkedList<Component>();
        ArrayList<JComponent> adjustables = new ArrayList<JComponent>();
        components.add(parent);
        while (components.size() > 0) {
            JComponent jcomp;
            Object comp = components.remove(0);
            if (comp instanceof JComponent && (jcomp = (JComponent)comp).getClientProperty(AUTO_ADJUST) != null) {
                adjustables.add(jcomp);
            }
            if (!(comp instanceof Container)) continue;
            Container container = (Container)comp;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                components.add(container.getComponent(i));
            }
        }
        if (adjustables.size() > 1) {
            JComponent[] jcomps = adjustables.toArray(new JComponent[adjustables.size()]);
            SGUI.adjustComponentSizes(jcomps);
        }
    }

    public static void setMinimumSize(JComponent c, int w, int h) {
        Dimension ms = c.getMinimumSize();
        Dimension ps = c.getPreferredSize();
        c.setMinimumSize(new Dimension(w < 0 ? ms.width : w, h < 0 ? ms.height : h));
        c.setPreferredSize(new Dimension(w < 0 ? ps.width : w, h < 0 ? ps.height : h));
    }

    public static void createVerticalGroupLayout(Container container, JComponent[] components, boolean fixedsize) {
        GroupLayout l = new GroupLayout(container);
        l.setAutoCreateContainerGaps(true);
        l.setAutoCreateGaps(true);
        container.setLayout(l);
        GroupLayout.SequentialGroup rhgroup = l.createSequentialGroup();
        GroupLayout.ParallelGroup hgroup = l.createParallelGroup();
        rhgroup.addGroup(hgroup);
        GroupLayout.SequentialGroup vgroup = l.createSequentialGroup();
        for (int i = 0; i < components.length; ++i) {
            container.add(components[i]);
            if (fixedsize) {
                hgroup.addComponent(components[i], -2, -2, -2);
                vgroup.addComponent(components[i], -2, -2, -2);
                continue;
            }
            hgroup.addComponent(components[i]);
            vgroup.addComponent(components[i]);
        }
        if (fixedsize) {
            SGUI.adjustComponentHorizontalSizes(components);
        }
        l.setHorizontalGroup(rhgroup);
        l.setVerticalGroup(vgroup);
    }

    public static void createHorizontalGroupLayout(Container container, JComponent[] components, boolean fixedsize) {
        GroupLayout l = new GroupLayout(container);
        l.setAutoCreateContainerGaps(true);
        l.setAutoCreateGaps(true);
        container.setLayout(l);
        GroupLayout.SequentialGroup hgroup = l.createSequentialGroup();
        GroupLayout.SequentialGroup rvgroup = l.createSequentialGroup();
        GroupLayout.ParallelGroup vgroup = l.createParallelGroup();
        rvgroup.addGroup(vgroup);
        for (int i = 0; i < components.length; ++i) {
            container.add(components[i]);
            if (fixedsize) {
                hgroup.addComponent(components[i], -2, -2, -2);
                vgroup.addComponent(components[i], -2, -2, -2);
                continue;
            }
            hgroup.addComponent(components[i]);
            vgroup.addComponent(components[i]);
        }
        if (fixedsize) {
            SGUI.adjustComponentHorizontalSizes(components);
        }
        l.setHorizontalGroup(hgroup);
        l.setVerticalGroup(rvgroup);
    }

    public static void createEdgelessHorizontalGroupLayout(Container container, JComponent[] components, boolean fixedsize) {
        SGUI.createEdgelessHorizontalGroupLayout(container, components, fixedsize, false);
    }

    public static void createEdgelessHorizontalGroupLayout(Container container, JComponent[] components, boolean fixedsize, boolean rightalign) {
        GroupLayout l = new GroupLayout(container);
        l.setAutoCreateContainerGaps(false);
        l.setAutoCreateGaps(true);
        container.setLayout(l);
        GroupLayout.SequentialGroup hgroup = l.createSequentialGroup();
        if (rightalign) {
            hgroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE);
        }
        GroupLayout.SequentialGroup rvgroup = l.createSequentialGroup();
        GroupLayout.ParallelGroup vgroup = l.createParallelGroup();
        rvgroup.addGroup(vgroup);
        for (int i = 0; i < components.length; ++i) {
            container.add(components[i]);
            if (fixedsize) {
                hgroup.addComponent(components[i], -2, -2, -2);
                vgroup.addComponent(components[i], -2, -2, -2);
                continue;
            }
            hgroup.addComponent(components[i]);
            vgroup.addComponent(components[i]);
        }
        if (!rightalign) {
            hgroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE);
        }
        if (fixedsize) {
            SGUI.adjustComponentHorizontalSizes(components);
        }
        l.setHorizontalGroup(hgroup);
        l.setVerticalGroup(rvgroup);
    }

    public static JTable createReadOnlyTable() {
        final JTextField editor = new JTextField();
        editor.setEditable(false);
        JTable table = new JTable();
        table.setBackground(editor.getBackground());
        table.setBorder(new LineBorder(table.getGridColor()));
        table.setDefaultEditor(Object.class, new TableCellEditor(){

            @Override
            public boolean stopCellEditing() {
                return true;
            }

            @Override
            public boolean shouldSelectCell(EventObject anEvent) {
                return true;
            }

            @Override
            public void removeCellEditorListener(CellEditorListener l) {
            }

            @Override
            public boolean isCellEditable(EventObject anEvent) {
                return true;
            }

            @Override
            public Object getCellEditorValue() {
                return null;
            }

            @Override
            public void cancelCellEditing() {
            }

            @Override
            public void addCellEditorListener(CellEditorListener l) {
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                editor.setText("" + value);
                Dimension dim = editor.getPreferredSize();
                editor.setBounds(new Rectangle(0, 0, dim.width, dim.height));
                return editor;
            }
        });
        return table;
    }

    public static double getProportionalDividerLocation(JSplitPane pane) {
        double full = pane.getOrientation() == 1 ? pane.getSize().getWidth() : pane.getSize().getHeight();
        double ret = (double)pane.getDividerLocation() / full;
        return ret;
    }

    public static Color stringToColor(String str) {
        if (str.length() == 0 || str.equalsIgnoreCase("Black")) {
            str = "#000000";
        } else if (str.equalsIgnoreCase("Silver")) {
            str = "#C0C0C0";
        } else if (str.equalsIgnoreCase("Gray")) {
            str = "#808080";
        } else if (str.equalsIgnoreCase("White")) {
            str = "#FFFFFF";
        } else if (str.equalsIgnoreCase("Maroon")) {
            str = "#800000";
        } else if (str.equalsIgnoreCase("Red")) {
            str = "#FF0000";
        } else if (str.equalsIgnoreCase("Purple")) {
            str = "#800080";
        } else if (str.equalsIgnoreCase("Fuchsia")) {
            str = "#FF00FF";
        } else if (str.equalsIgnoreCase("Green")) {
            str = "#008000";
        } else if (str.equalsIgnoreCase("Lime")) {
            str = "#00FF00";
        } else if (str.equalsIgnoreCase("Olive")) {
            str = "#808000";
        } else if (str.equalsIgnoreCase("Yellow")) {
            str = "#FFFF00";
        } else if (str.equalsIgnoreCase("Navy")) {
            str = "#000080";
        } else if (str.equalsIgnoreCase("Blue")) {
            str = "#0000FF";
        } else if (str.equalsIgnoreCase("Teal")) {
            str = "#008080";
        } else if (str.equalsIgnoreCase("Aqua")) {
            str = "#00FFFF";
        }
        Color ret = null;
        if (str.startsWith("#")) {
            String b = str.substring(5, 7);
            String g = str.substring(3, 5);
            String r = str.substring(1, 3);
            if (str.length() == 9) {
                String alpha = str.substring(7);
                ret = new Color(Integer.parseInt(r, 16), Integer.parseInt(g, 16), Integer.parseInt(b, 16), Integer.parseInt(alpha, 16));
            } else {
                ret = new Color(Integer.parseInt(r, 16), Integer.parseInt(g, 16), Integer.parseInt(b, 16));
            }
        }
        return ret;
    }

    public static String colorToHTML(Color color) {
        return "#" + Integer.toHexString(color.getRed()) + Integer.toHexString(color.getGreen()) + Integer.toHexString(color.getBlue());
    }

    public static String fontToHTML(Font font) {
        String style = font.isBold() ? (font.isItalic() ? "bolditalic " : "bold ") : (font.isItalic() ? "italic " : "");
        return style + font.getSize() + " " + font.getName();
    }

    public static final BufferedImage scaleImage(Image src, int w, int h, int type) {
        Image img = src.getScaledInstance(w, h, type);
        BufferedImage ret = new BufferedImage(w, h, 7);
        Graphics2D g = ret.createGraphics();
        g.drawImage(img, 0, 0, new Color(0, 0, 0, 0), null);
        g.dispose();
        return ret;
    }

    public static final BufferedImage convertBufferedImageType(BufferedImage original, int type) {
        BufferedImage ret = new BufferedImage(original.getWidth(), original.getHeight(), type);
        Graphics2D g = ret.createGraphics();
        g.drawImage((Image)original, 0, 0, null);
        g.dispose();
        return ret;
    }

    public static int getSelectedButton(ButtonGroup bg) {
        int ret = -1;
        Enumeration<AbstractButton> enumer = bg.getElements();
        int i = 0;
        while (enumer.hasMoreElements()) {
            if (enumer.nextElement().isSelected()) {
                ret = i;
                break;
            }
            ++i;
        }
        return ret;
    }

    public static void setAllEnabled(ButtonGroup bg, boolean enabled) {
        Enumeration<AbstractButton> enumer = bg.getElements();
        while (enumer.hasMoreElements()) {
            enumer.nextElement().setEnabled(enabled);
        }
    }

    public static final BufferedImage scaleBufferedImage(BufferedImage original, int w, int h) {
        Image scaled = original.getScaledInstance(w, h, 16);
        BufferedImage ret = new BufferedImage(w, h, original.getType());
        Graphics2D g = ret.createGraphics();
        g.drawImage(scaled, 0, 0, null);
        g.dispose();
        return ret;
    }

    public static void invokeLater(Runnable runnable) {
        SwingUtilities.invokeLater(runnable);
    }

    public static void invokeLaterSimBlock(Runnable runnable) {
        if (!SReflect.HAS_GUI || SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            Future adblock = SSimulation.block();
            SwingUtilities.invokeLater(() -> {
                try {
                    runnable.run();
                }
                finally {
                    if (adblock != null) {
                        adblock.setResult(null);
                    }
                }
            });
        }
    }

    public static final String getText(JTextArea area) {
        Document doc = area.getDocument();
        String ret = null;
        try {
            ret = doc.getText(0, doc.getLength());
            if (ret.length() == 0) {
                ret = null;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return ret;
    }

    public static final void setText(JTextArea area, String text) {
        Document doc = area.getDocument();
        try {
            doc.remove(0, doc.getLength());
            doc.insertString(0, text, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public static void addCopyPasteMenu(JTextComponent textcomponent) {
        textcomponent.addMouseListener(new TextCopyPasteMouseListener(textcomponent));
    }

    public static void removeCopyPasteMenu(JTextComponent textcomponent) {
        for (MouseListener lis : textcomponent.getMouseListeners()) {
            if (!(lis instanceof TextCopyPasteMouseListener)) continue;
            textcomponent.removeMouseListener(lis);
            break;
        }
    }

    public static double[] colorToRgba(Color color) {
        double[] ret = new double[]{(double)color.getRed() / 255.0, (double)color.getGreen() / 255.0, (double)color.getBlue() / 255.0, (double)color.getAlpha() / 255.0};
        return ret;
    }

    public static Color rgbaToColor(double[] rgba) {
        assert (rgba != null && rgba.length == 4);
        return new Color((float)rgba[0], (float)rgba[1], (float)rgba[2], (float)rgba[3]);
    }

    static {
        BROKEN_UI_IDS.add("GTK");
    }

    public static class TextCopyPasteMouseListener
    extends MouseAdapter {
        protected JTextComponent textcomponent;

        public TextCopyPasteMouseListener(JTextComponent textcomponent) {
            this.textcomponent = textcomponent;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                JCopyPasteContextMenu popup = new JCopyPasteContextMenu(this.textcomponent);
                popup.show(this.textcomponent, e.getX(), e.getY());
            }
        }
    }
}

