/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui;

import jadex.commons.IFilter;
import jadex.commons.SUtil;
import jadex.commons.future.CounterResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ISubscriptionIntermediateFuture;
import jadex.commons.future.IntermediateEmptyResultListener;
import jadex.commons.future.SubscriptionIntermediateFuture;
import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class SDirScan {
    public static ISubscriptionIntermediateFuture<Class<?>> asyncScanForClasses(ClassLoader classloader, IFilter<Object> filefilter, IFilter<Class<?>> classfilter, int max, boolean includebootpath) {
        return SDirScan.asyncScanForClasses(SUtil.getClasspathURLs((ClassLoader)classloader, (boolean)includebootpath).toArray(new URL[0]), classloader, filefilter, classfilter, max);
    }

    public static ISubscriptionIntermediateFuture<Class<?>> asyncScanForClasses(final URL[] urls, ClassLoader classloader, IFilter<Object> filefilter, final IFilter<Class<?>> classfilter, final int max) {
        final SubscriptionIntermediateFuture ret = new SubscriptionIntermediateFuture();
        final ClassLoader[] newcl = new ClassLoader[1];
        final int[] cnt = new int[1];
        final ISubscriptionIntermediateFuture<String> fut = SDirScan.asyncScanForFiles(urls, filefilter);
        fut.addResultListener((IResultListener)new IntermediateEmptyResultListener<String>(){
            int resultcnt = 0;

            public void intermediateResultAvailable(String file) {
                try {
                    Class<?> tmpcl;
                    String clname;
                    block8: {
                        block7: {
                            clname = file.substring(0, file.length() - 6).replace('/', '.');
                            if (newcl[0] == null) break block7;
                            int n = cnt[0];
                            cnt[0] = n + 1;
                            if (n % 500 != 0) break block8;
                        }
                        newcl[0] = new URLClassLoader(urls, null);
                    }
                    if ((tmpcl = Class.forName(clname, false, newcl[0])) != null && classfilter.filter(tmpcl) && (max > 0 && ++this.resultcnt > max || !ret.addIntermediateResultIfUndone(tmpcl))) {
                        fut.terminate();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            public void resultAvailable(Collection<String> result) {
                for (String res : result) {
                    this.intermediateResultAvailable(res);
                }
                this.finished();
            }

            public void exceptionOccurred(Exception exception) {
                ret.setExceptionIfUndone(exception);
            }

            public void finished() {
                ret.setFinishedIfUndone();
            }
        });
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISubscriptionIntermediateFuture<String> asyncScanForFiles(URL[] urls, IFilter<Object> filter) {
        final SubscriptionIntermediateFuture ret = new SubscriptionIntermediateFuture();
        if (urls.length == 0) {
            ret.setFinished();
            return ret;
        }
        final CounterResultListener lis = new CounterResultListener(urls.length, true, (IResultListener)new IResultListener<Void>(){

            public void resultAvailable(Void result) {
                ret.setFinishedIfUndone();
            }

            public void exceptionOccurred(Exception exception) {
                ret.setExceptionIfUndone(exception);
            }
        });
        for (int i = 0; i < urls.length && !ret.isDone(); ++i) {
            try {
                URL url = urls[i];
                int fi = i;
                File f = new File(urls[i].toURI());
                if (f.getName().endsWith(".jar")) {
                    try (JarFile jar = null;){
                        jar = new JarFile(f);
                        Enumeration<JarEntry> e = jar.entries();
                        while (e.hasMoreElements() && !ret.isDone()) {
                            JarEntry je = e.nextElement();
                            if (!filter.filter((Object)je)) continue;
                            ret.addIntermediateResultIfUndone((Object)je.getName());
                        }
                    }
                    lis.resultAvailable(null);
                    continue;
                }
                if (f.isDirectory()) {
                    final ISubscriptionIntermediateFuture<String> fut = SDirScan.asyncScanDir(urls, f, filter, new ArrayList<String>());
                    fut.addResultListener((IResultListener)new IntermediateEmptyResultListener<String>(){

                        public void intermediateResultAvailable(String result) {
                            if (!ret.addIntermediateResultIfUndone((Object)result)) {
                                fut.terminate();
                            }
                        }

                        public void finished() {
                            lis.resultAvailable(null);
                        }

                        public void resultAvailable(Collection<String> result) {
                            for (String res : result) {
                                this.intermediateResultAvailable(res);
                            }
                            this.finished();
                        }

                        public void exceptionOccurred(Exception exception) {
                            lis.exceptionOccurred(exception);
                        }
                    });
                    continue;
                }
                lis.resultAvailable(null);
                continue;
            }
            catch (Exception e) {
                lis.exceptionOccurred(e);
                System.out.println("scan problem with: " + urls[i]);
            }
        }
        return ret;
    }

    public static ISubscriptionIntermediateFuture<String> asyncScanDir(URL[] urls, File file, IFilter filter, List<String> donedirs) {
        String fn;
        File fi;
        File[] files;
        final SubscriptionIntermediateFuture ret = new SubscriptionIntermediateFuture();
        File[] fileArray = files = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return !f.isDirectory();
            }
        });
        int n = fileArray.length;
        for (int i = 0; !(i >= n || (fi = fileArray[i]).getName().endsWith(".class") && filter.filter((Object)fi) && !ret.addIntermediateResultIfUndone((Object)((fn = SUtil.convertPathToPackage((String)fi.getAbsolutePath(), (URL[])urls)) + "." + fi.getName()))); ++i) {
        }
        if (file.isDirectory() && !ret.isDone()) {
            donedirs.add(file.getAbsolutePath());
            File[] sudirs = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory();
                }
            });
            if (sudirs.length > 0) {
                final CounterResultListener lis = new CounterResultListener(sudirs.length, (IResultListener)new IResultListener<Void>(){

                    public void resultAvailable(Void result) {
                        ret.setFinishedIfUndone();
                    }

                    public void exceptionOccurred(Exception exception) {
                        ret.setExceptionIfUndone(exception);
                    }
                });
                for (File dir : sudirs) {
                    if (donedirs.contains(dir.getAbsolutePath())) continue;
                    final ISubscriptionIntermediateFuture<String> fut = SDirScan.asyncScanDir(urls, dir, filter, donedirs);
                    fut.addResultListener((IResultListener)new IntermediateEmptyResultListener<String>(){

                        public void intermediateResultAvailable(String result) {
                            if (!ret.addIntermediateResultIfUndone((Object)result)) {
                                fut.terminate();
                            }
                        }

                        public void finished() {
                            lis.resultAvailable(null);
                        }

                        public void resultAvailable(Collection<String> result) {
                            for (String res : result) {
                                this.intermediateResultAvailable(res);
                            }
                            this.finished();
                        }

                        public void exceptionOccurred(Exception exception) {
                            lis.exceptionOccurred(exception);
                        }
                    });
                }
            } else {
                ret.setFinishedIfUndone();
            }
        } else {
            ret.setFinishedIfUndone();
        }
        return ret;
    }
}

