/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class PropertiesPanel
extends JPanel {
    protected GridBagConstraints gbc;
    protected JComponent dummy;
    protected Map components;
    protected boolean adddummy;

    public PropertiesPanel() {
        this((String)null);
    }

    public PropertiesPanel(String title) {
        super(new GridBagLayout());
        if (title != null) {
            this.setBorder(new TitledBorder(new EtchedBorder(1), title));
        }
        this.components = new HashMap();
        this.gbc = new GridBagConstraints();
        this.gbc.gridy = 0;
        this.gbc.anchor = 19;
        this.gbc.fill = 2;
        this.gbc.insets = new Insets(1, 1, 1, 1);
        this.adddummy = true;
        this.dummy = new JLabel();
        this.gbc.weighty = 1.0;
        this.add((Component)this.dummy, this.gbc);
        this.gbc.weighty = 0.0;
    }

    public JTextField getTextField(String name) {
        return (JTextField)this.components.get(name);
    }

    public JComponent getComponent(String name) {
        return (JComponent)this.components.get(name);
    }

    public JCheckBox getCheckBox(String name) {
        return (JCheckBox)this.components.get(name);
    }

    public JComboBox getComboBox(String name) {
        return (JComboBox)this.components.get(name);
    }

    public JTextField createTextField(String name) {
        return this.createTextField(name, null);
    }

    public JTextField createTextField(String name, String defvalue) {
        return this.createTextField(name, defvalue, false, 0.0);
    }

    public JTextField createTextField(String name, String defvalue, boolean editable) {
        return this.createTextField(name, defvalue, editable, 0.0);
    }

    public JTextField createTextField(String name, String defvalue, boolean editable, double weighty) {
        return this.createTextField(name, defvalue, editable, weighty, null);
    }

    public JTextField createTextField(String name, String defvalue, boolean editable, double weighty, String tooltip) {
        JTextField tf = new JTextField(defvalue);
        tf.setEditable(editable);
        this.addComponent(name, tf, weighty, -1, -1, tooltip);
        return tf;
    }

    public JCheckBox createCheckBox(String name) {
        return this.createCheckBox(name, false, false, 0.0);
    }

    public JCheckBox createCheckBox(String name, boolean selected, boolean enabled) {
        return this.createCheckBox(name, selected, enabled, 0.0);
    }

    public JCheckBox createCheckBox(String name, boolean selected, boolean enabled, double weighty) {
        return this.createCheckBox(name, selected, enabled, weighty, null);
    }

    public JCheckBox createCheckBox(String name, boolean selected, boolean enabled, double weighty, String tooltip) {
        JCheckBox cb = new JCheckBox("", selected);
        cb.setMargin(new Insets(0, 0, 0, 0));
        cb.setEnabled(enabled);
        this.addComponent(name, cb, weighty, -1, -1, tooltip);
        return cb;
    }

    public JComboBox createComboBox(String name, Object[] values) {
        return this.createComboBox(name, values, false, 0.0);
    }

    public JComboBox createComboBox(String name, Object[] values, boolean editable, double weighty) {
        JComboBox cb = values == null ? new JComboBox() : new JComboBox<Object>(values);
        cb.setEditable(editable);
        this.addComponent(name, cb, weighty, -1);
        return cb;
    }

    public JButton createButton(String name, String text) {
        return this.createButton(name, text, 0.0);
    }

    public JButton createButton(String name, String text, double weighty) {
        JButton b = new JButton(text);
        this.addComponent(name, b, weighty, 0, 17, null);
        return b;
    }

    public JButton[] createButtons(String groupname, String[] names, double weighty) {
        int i;
        JButton[] ret = new JButton[names.length];
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints con = new GridBagConstraints();
        con.gridx = 0;
        con.gridy = 0;
        con.anchor = 13;
        con.fill = 0;
        con.insets = new Insets(1, 1, 1, 1);
        con.weightx = 1.0;
        Dimension maxd = null;
        for (i = 0; i < names.length; ++i) {
            ret[i] = new JButton(names[i]);
            p.add((Component)ret[i], con);
            con.weightx = 0.0;
            ++con.gridx;
            Dimension d = ret[i].getPreferredSize();
            if (maxd != null && d.width <= maxd.width) continue;
            maxd = d;
        }
        for (i = 0; i < ret.length; ++i) {
            ret[i].setPreferredSize(maxd);
        }
        this.addFullLineComponent(groupname, p, weighty);
        return ret;
    }

    public void addComponent(String name, JComponent comp) {
        this.addComponent(name, comp, 0.0, -1);
    }

    public void addComponent(String name, JComponent comp, double weighty) {
        this.addComponent(name, comp, weighty, -1);
    }

    public void addComponent(String name, JComponent comp, double weighty, int fill) {
        this.addComponent(name, comp, weighty, fill, -1, null);
    }

    public void addComponent(String name, JComponent comp, double weighty, int fill, int anchor, String tooltip) {
        this.components.put(name, comp);
        this.remove(this.dummy);
        this.gbc.weighty = weighty;
        this.gbc.weightx = 0.0;
        this.gbc.gridwidth = 1;
        this.gbc.anchor = anchor != -1 ? anchor : 13;
        this.gbc.fill = 1;
        JLabel lab = new JLabel(name);
        if (tooltip != null) {
            lab.setToolTipText(tooltip);
        }
        this.add((Component)lab, this.gbc);
        if (weighty == 0.0) {
            this.gbc.fill = fill != -1 ? fill : 2;
        } else {
            this.adddummy = false;
        }
        this.gbc.weightx = 1.0;
        this.gbc.gridwidth = 0;
        if (tooltip != null) {
            comp.setToolTipText(tooltip);
        }
        this.add((Component)comp, this.gbc);
        ++this.gbc.gridy;
        this.gbc.fill = 2;
        if (this.adddummy) {
            this.gbc.weighty = 1.0;
            this.gbc.gridwidth = 0;
            this.add((Component)this.dummy, this.gbc);
            this.gbc.gridwidth = 1;
            this.gbc.weighty = 0.0;
        }
    }

    public void addFullLineComponent(String name, JComponent comp) {
        this.addFullLineComponent(name, comp, 0.0);
    }

    public void addFullLineComponent(String name, JComponent comp, double weighty) {
        this.components.put(name, comp);
        this.remove(this.dummy);
        this.gbc.weighty = weighty;
        if (weighty > 0.0) {
            this.gbc.fill = 1;
            this.adddummy = false;
        }
        this.gbc.weightx = 1.0;
        this.gbc.gridwidth = 0;
        this.add((Component)comp, this.gbc);
        ++this.gbc.gridy;
        this.gbc.fill = 2;
        if (this.adddummy) {
            this.gbc.weighty = 1.0;
            this.add((Component)this.dummy, this.gbc);
            this.gbc.gridwidth = 1;
            this.gbc.weighty = 0.0;
        }
    }
}

