/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class ObjectCardLayout
implements LayoutManager2 {
    public static final String DEFAULT_COMPONENT = "jtc_ocl_default_component";
    protected int hgap = 0;
    protected int vgap = 0;
    protected Map<Object, Component> components = new LinkedHashMap<Object, Component>();
    protected Component current;
    protected Object curkey;

    public void show(Object object) {
        Component comp;
        assert (SwingUtilities.isEventDispatchThread());
        if (this.current != null) {
            this.current.setVisible(false);
        }
        if ((comp = this.components.get(object)) == null) {
            comp = this.components.get(DEFAULT_COMPONENT);
            this.curkey = null;
        } else {
            this.curkey = object;
            this.components.remove(object);
            this.components.put(object, comp);
        }
        if (comp != null && comp.getParent() != null) {
            comp.setVisible(true);
            comp.getParent().validate();
        }
        this.current = comp;
    }

    public boolean isAvailable(Object object) {
        assert (SwingUtilities.isEventDispatchThread());
        return this.components.containsKey(object);
    }

    public Component getComponent(Object object) {
        assert (SwingUtilities.isEventDispatchThread());
        return this.components.get(object);
    }

    public Object getCurrentKey() {
        return this.curkey;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        assert (SwingUtilities.isEventDispatchThread());
        this.addLayoutComponent(comp, name);
    }

    @Override
    public void layoutContainer(Container parent) {
        assert (SwingUtilities.isEventDispatchThread());
        Insets insets = parent.getInsets();
        Rectangle bounds = parent.getBounds();
        int ncomponents = parent.getComponentCount();
        for (int i = 0; i < ncomponents; ++i) {
            Component comp = parent.getComponent(i);
            if (!comp.isVisible()) continue;
            comp.setBounds(this.hgap + insets.left, this.vgap + insets.top, bounds.width - (this.hgap * 2 + insets.left + insets.right), bounds.height - (this.vgap * 2 + insets.top + insets.bottom));
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        assert (SwingUtilities.isEventDispatchThread());
        Insets insets = parent.getInsets();
        int ncomponents = parent.getComponentCount();
        int w = 0;
        int h = 0;
        for (int i = 0; i < ncomponents; ++i) {
            Component comp = parent.getComponent(i);
            Dimension d = comp.getMinimumSize();
            if (d.width > w) {
                w = d.width;
            }
            if (d.height <= h) continue;
            h = d.height;
        }
        return new Dimension(insets.left + insets.right + w + this.hgap * 2, insets.top + insets.bottom + h + this.vgap * 2);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        assert (SwingUtilities.isEventDispatchThread());
        Insets insets = parent.getInsets();
        int ncomponents = parent.getComponentCount();
        int w = 0;
        int h = 0;
        for (int i = 0; i < ncomponents; ++i) {
            Component comp = parent.getComponent(i);
            Dimension d = comp.getPreferredSize();
            if (d.width > w) {
                w = d.width;
            }
            if (d.height <= h) continue;
            h = d.height;
        }
        return new Dimension(insets.left + insets.right + w + this.hgap * 2, insets.top + insets.bottom + h + this.vgap * 2);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        assert (SwingUtilities.isEventDispatchThread());
        Iterator<Component> i = this.components.values().iterator();
        while (i.hasNext()) {
            if (!i.next().equals(comp)) continue;
            i.remove();
            break;
        }
        if (comp == this.current) {
            comp.getParent().repaint();
            Object show = null;
            Iterator<Object> iterator = this.components.keySet().iterator();
            while (iterator.hasNext()) {
                Object tmp;
                show = tmp = iterator.next();
            }
            this.show(show != null ? show : DEFAULT_COMPONENT);
        }
    }

    @Override
    public void addLayoutComponent(Component component, Object constraints) {
        assert (SwingUtilities.isEventDispatchThread());
        if (constraints == null) {
            throw new RuntimeException("no_object_for_card_specified");
        }
        this.components.put(constraints, component);
        component.setVisible(false);
        this.show(constraints);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return null;
    }

    public String toString() {
        return this.getClass().getName();
    }
}

