/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui;

import java.awt.Color;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class ModulateComposite
implements Composite {
    protected Color modcolor;

    public ModulateComposite(Color modcolor) {
        this.modcolor = modcolor;
    }

    @Override
    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        return new ModulationContext(srcColorModel, dstColorModel);
    }

    protected class ModulationContextAccel
    implements CompositeContext {
        protected ColorModel srcColorModel;
        protected ColorModel dstColorModel;

        public ModulationContextAccel(ColorModel srcColorModel, ColorModel dstColorModel) {
            this.srcColorModel = srcColorModel;
            this.dstColorModel = dstColorModel;
        }

        @Override
        public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
            float[] clrPx = ModulateComposite.this.modcolor.getComponents(null);
            int maxX = Math.min(src.getWidth(), dstIn.getWidth());
            int maxY = Math.min(src.getHeight(), dstIn.getHeight());
            for (int y = 0; y < maxY; ++y) {
                for (int x = 0; x < maxX; ++x) {
                    Object inPixel = src.getDataElements(x, y, null);
                    byte[] bPixel = (byte[])inPixel;
                    bPixel[0] = (byte)((float)(bPixel[0] & 0xFF) / 255.0f * clrPx[0] * 255.0f);
                    bPixel[1] = (byte)((float)(bPixel[1] & 0xFF) / 255.0f * clrPx[1] * 255.0f);
                    bPixel[2] = (byte)((float)(bPixel[2] & 0xFF) / 255.0f * clrPx[2] * 255.0f);
                    bPixel[3] = (byte)((float)(bPixel[3] & 0xFF) / 255.0f * clrPx[3] * 255.0f);
                    dstOut.setDataElements(x, y, bPixel);
                }
            }
        }

        @Override
        public void dispose() {
            this.srcColorModel = null;
            this.dstColorModel = null;
        }
    }

    protected class ModulationContext
    implements CompositeContext {
        protected ColorModel srcColorModel;
        protected ColorModel dstColorModel;

        public ModulationContext(ColorModel srcColorModel, ColorModel dstColorModel) {
            this.srcColorModel = srcColorModel;
            this.dstColorModel = dstColorModel;
        }

        @Override
        public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
            float[] clrPx = ModulateComposite.this.modcolor.getComponents(null);
            int maxX = Math.min(src.getWidth(), dstIn.getWidth());
            int maxY = Math.min(src.getHeight(), dstIn.getHeight());
            float[] tmpPx = new float[4];
            for (int y = 0; y < maxY; ++y) {
                for (int x = 0; x < maxX; ++x) {
                    Object inPixel = src.getDataElements(x, y, null);
                    tmpPx = this.srcColorModel.getNormalizedComponents(inPixel, tmpPx, 0);
                    tmpPx[0] = tmpPx[0] * clrPx[0];
                    tmpPx[1] = tmpPx[1] * clrPx[1];
                    tmpPx[2] = tmpPx[2] * clrPx[2];
                    tmpPx[3] = tmpPx[3] * clrPx[3];
                    Object outPixel = this.dstColorModel.getDataElements(tmpPx, 0, null);
                    dstOut.setDataElements(x, y, outPixel);
                }
            }
        }

        @Override
        public void dispose() {
            this.srcColorModel = null;
            this.dstColorModel = null;
        }
    }
}

