/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui;

import jadex.commons.ICommand;
import jadex.commons.collection.IdentityHashSet;
import jadex.commons.gui.JBusyRing;
import jadex.commons.gui.SGUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class JWizard
extends JPanel {
    private static final long serialVersionUID = 4992471651678269871L;
    public static final int FINISH_ID = 0;
    public static final int CANCEL_ID = 1;
    protected WizardNode start;
    protected WizardNode current;
    protected JPanel mainpanel;
    protected JPanel buttonpanel;
    protected JButton nextbutton;
    protected JBusyRing busyring;
    protected Set<ActionListener> terminationlisteners = new LinkedHashSet<ActionListener>();

    public JWizard() {
        this.mainpanel = new JPanel();
        this.mainpanel.setLayout(new GridLayout(1, 1));
        this.busyring = new JBusyRing();
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainpanel, "Center");
    }

    public void setAllButtonsEnabled(boolean enabled) {
        Component[] comps;
        for (Component comp : comps = this.buttonpanel.getComponents()) {
            if (!(comp instanceof AbstractButton)) continue;
            comp.setEnabled(enabled);
        }
    }

    public void setEnableNext(boolean enabled) {
        this.nextbutton.setEnabled(enabled);
    }

    public void finish() {
        for (ActionListener lis : this.terminationlisteners) {
            ActionEvent e = new ActionEvent(this, 0, "Finished");
            lis.actionPerformed(e);
        }
    }

    public void cancel() {
        for (ActionListener lis : this.terminationlisteners) {
            ActionEvent e = new ActionEvent(this, 1, "Canceled");
            lis.actionPerformed(e);
        }
    }

    public void addTerminationListener(ActionListener lis) {
        this.terminationlisteners.add(lis);
    }

    public void removeTerminationListener(ActionListener lis) {
        this.terminationlisteners.remove(lis);
    }

    protected void next() {
        if (this.current != null) {
            this.mainpanel.remove(this.current);
            WizardNode next = this.current.getSelectedChild();
            next.getParentNodeStack().push(this.current);
            this.current = next;
        } else {
            this.current = this.start;
        }
        this.mainpanel.add((Component)this.current, "Center");
        this.configureButtons();
        this.current.onShow();
    }

    protected void back() {
        if (this.current != null) {
            this.mainpanel.remove(this.current);
            this.current.getSelectedChild();
            this.current = this.current.getParentNodeStack().pop();
        } else {
            this.current = this.start;
        }
        this.mainpanel.add((Component)this.current, "Center");
        this.current.onShow();
        this.configureButtons();
    }

    protected void reset() {
        if (this.current != null) {
            this.current.getSelectedChild();
            this.mainpanel.remove(this.current);
        }
        this.current = null;
        this.performOnAllNodes(new ICommand<WizardNode>(){

            public void execute(WizardNode arg) {
                arg.getParentNodeStack().clear();
            }
        });
    }

    protected void performOnAllNodes(ICommand<WizardNode> command) {
        IdentityHashSet known = new IdentityHashSet();
        this.performOnAllNodesRecur(command, this.start, (Set<WizardNode>)known);
    }

    protected void performOnAllNodesRecur(ICommand<WizardNode> command, WizardNode node, Set<WizardNode> known) {
        if (!known.contains(node)) {
            WizardNode[] children;
            known.add(node);
            command.execute((Object)node);
            for (WizardNode child : children = node.getChildren().toArray(new WizardNode[node.getChildren().size()])) {
                this.performOnAllNodesRecur(command, child, known);
            }
        }
    }

    protected void configureButtons() {
        if (this.buttonpanel != null) {
            this.buttonpanel.remove(this.busyring);
            this.remove(this.buttonpanel);
        }
        this.buttonpanel = new JPanel();
        BoxLayout layout = new BoxLayout(this.buttonpanel, 2);
        this.buttonpanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.BLACK));
        this.buttonpanel.setLayout(layout);
        JButton backbutton = new JButton(new AbstractAction("< Back"){
            private static final long serialVersionUID = 8555507317815950243L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JWizard.this.current.onBack();
                    JWizard.this.back();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        backbutton.setEnabled(!this.current.getParentNodeStack().isEmpty());
        AbstractAction nextaction = null;
        nextaction = this.current.getChildren().size() != 0 ? new AbstractAction("Next >"){
            private static final long serialVersionUID = -4975918469003714414L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JWizard.this.current.onNext();
                    JWizard.this.next();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } : new AbstractAction("Finish"){
            private static final long serialVersionUID = 4923957179445964525L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JWizard.this.current.onFinish();
                    JWizard.this.finish();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        };
        this.nextbutton = new JButton(nextaction);
        JButton cancelbutton = new JButton(new AbstractAction("Cancel"){
            private static final long serialVersionUID = 2198620502764979156L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JWizard.this.current.onCancel();
                    JWizard.this.cancel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.buttonpanel.add(this.busyring);
        this.buttonpanel.add(Box.createHorizontalGlue());
        this.buttonpanel.add(backbutton);
        this.buttonpanel.add(this.nextbutton);
        this.buttonpanel.add(Box.createHorizontalStrut(10));
        this.buttonpanel.add(cancelbutton);
        this.buttonpanel.add(Box.createHorizontalStrut(10));
        this.add((Component)this.buttonpanel, "South");
        this.invalidate();
        this.validate();
        this.doLayout();
        this.repaint();
    }

    public static final JFrame createFrame(String title, JWizard wizard) {
        final JFrame frame = new JFrame(title);
        frame.setDefaultCloseOperation(2);
        frame.getRootPane().setLayout(new BorderLayout());
        frame.getRootPane().add((Component)wizard, "Center");
        frame.setSize(800, 600);
        frame.setMinimumSize(frame.getRootPane().getPreferredSize());
        frame.setLocation(SGUI.calculateMiddlePosition(frame));
        wizard.addTerminationListener(new AbstractAction(){
            private static final long serialVersionUID = 9133682067352852751L;

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.dispose();
            }
        });
        return frame;
    }

    public static class ChoiceNode
    extends WizardNode {
        private static final long serialVersionUID = 1634355685705747180L;
        protected ButtonGroup bgroup = new ButtonGroup();

        public ChoiceNode(String choicetitle, String[] choices) {
            this(choicetitle, choices, 0);
        }

        public ChoiceNode(String choicetitle, String[] choices, int defaultchoice) {
            JComponent[] buttons = new JComponent[choices.length];
            for (int i = 0; i < choices.length; ++i) {
                JRadioButton choicebutton = new JRadioButton(choices[i]);
                if (i == defaultchoice) {
                    choicebutton.setSelected(true);
                }
                this.bgroup.add(choicebutton);
                buttons[i] = choicebutton;
            }
            JPanel inner = new JPanel();
            if (choicetitle != null) {
                inner.setBorder(BorderFactory.createTitledBorder(choicetitle));
            } else {
                inner.setBorder(BorderFactory.createEtchedBorder());
            }
            SGUI.createVerticalGroupLayout(inner, buttons, true);
            this.setLayout(new BorderLayout());
            this.add((Component)inner, "Center");
        }

        @Override
        public WizardNode getSelectedChild() {
            int sel = SGUI.getSelectedButton(this.bgroup);
            return (WizardNode)this.children.get(sel);
        }
    }

    protected static class WizardNode
    extends JPanel {
        private static final long serialVersionUID = 7657673980110325857L;
        protected LinkedList<WizardNode> parents = new LinkedList();
        protected List<WizardNode> children = new ArrayList<WizardNode>();
        protected int nextitem;

        public void onShow() {
        }

        public void addCentered(JComponent comp) {
            this.setLayout(new BoxLayout(this, 3));
            Box hbox = Box.createHorizontalBox();
            hbox.add(Box.createHorizontalGlue());
            hbox.add(comp);
            hbox.add(Box.createHorizontalGlue());
            Box vbox = Box.createVerticalBox();
            vbox.add(Box.createVerticalGlue());
            vbox.add(hbox);
            vbox.add(Box.createVerticalGlue());
            this.add(vbox);
        }

        public void addChild(WizardNode child) {
            this.children.add(child);
        }

        public void removeChild(WizardNode child) {
            this.children.remove(child);
        }

        public List<WizardNode> getChildren() {
            return this.children;
        }

        public void setChildren(List<WizardNode> children) {
            this.children = children;
        }

        public LinkedList<WizardNode> getParentNodeStack() {
            return this.parents;
        }

        public WizardNode getSelectedChild() {
            int sel = this.nextitem;
            this.nextitem = 0;
            return sel < this.children.size() ? this.children.get(sel) : null;
        }

        protected void onFinish() {
            this.onNext();
        }

        protected void onNext() {
        }

        protected void onBack() {
        }

        protected void onCancel() {
        }
    }
}

