/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JSplitPane;

public class JSplitPanel
extends JSplitPane {
    int isPainted = 3;
    boolean hasProportionalLocation = false;
    double proportionalLocation;

    public JSplitPanel() {
    }

    public JSplitPanel(int newOrientation) {
        super(newOrientation);
    }

    public JSplitPanel(int newOrientation, boolean newContinuousLayout) {
        super(newOrientation, newContinuousLayout);
    }

    public JSplitPanel(int newOrientation, Component newLeftComponent, Component newRightComponent) {
        super(newOrientation, newLeftComponent, newRightComponent);
    }

    public JSplitPanel(int newOrientation, boolean newContinuousLayout, Component newLeftComponent, Component newRightComponent) {
        super(newOrientation, newContinuousLayout, newLeftComponent, newRightComponent);
    }

    @Override
    public void setDividerLocation(double proportionalLocation) {
        if (proportionalLocation < 0.0 || proportionalLocation > 1.0) {
            return;
        }
        if (this.isPainted > 0) {
            this.hasProportionalLocation = true;
            this.proportionalLocation = proportionalLocation;
        } else {
            super.setDividerLocation(proportionalLocation);
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.isPainted > 0 && this.isValid() && this.isVisible()) {
            super.setDividerLocation(this.proportionalLocation);
            --this.isPainted;
        }
        super.paint(g);
    }

    public double getProportionalDividerLocation() {
        double full = this.getOrientation() == 1 ? (double)(this.getWidth() - this.getDividerSize()) : (double)(this.getHeight() - this.getDividerSize());
        double ret = full <= 0.0 ? 0.0 : (double)this.getDividerLocation() / full;
        return ret;
    }
}

