/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui;

import jadex.commons.gui.SGUI;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractAction;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Highlighter;

public class JPlaceholderTextField
extends JTextField {
    protected boolean activeplaceholder = true;
    protected String placeholder = "";
    protected Color placeholdercolor;
    protected Color foregroundcolor;
    protected RecolorLineBorder border;
    protected Timer animtimer;
    protected Color origcolor;
    protected Color invalidcolor;
    protected DocumentListener doclistener;
    protected Highlighter highlighter = this.getHighlighter();

    public JPlaceholderTextField() {
        this.placeholdercolor = Color.LIGHT_GRAY;
        this.invalidcolor = Color.RED;
        this.foregroundcolor = super.getForeground();
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                JPlaceholderTextField.this.setCaretPosition(0);
            }
        });
        this.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                if (JPlaceholderTextField.this.activeplaceholder) {
                    JPlaceholderTextField.this.removeCaretListener(this);
                    JPlaceholderTextField.this.setCaretPosition(0);
                    JPlaceholderTextField.this.addCaretListener(this);
                }
            }
        });
        this.doclistener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(final DocumentEvent e) {
                if ("".equals(JPlaceholderTextField.super.getText())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (DocumentEvent.EventType.REMOVE.equals(e.getType())) {
                                JPlaceholderTextField.super.setText("");
                            }
                            JPlaceholderTextField.this.activatePlaceholder();
                        }
                    });
                } else if (JPlaceholderTextField.this.activeplaceholder) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JPlaceholderTextField.this.deactivatePlaceholder();
                        }
                    });
                }
            }
        };
        this.getDocument().addDocumentListener(this.doclistener);
        SGUI.addCopyPasteMenu(this);
        if (SGUI.BROKEN_UI_IDS.contains(UIManager.getLookAndFeel().getID())) {
            int s = 3;
            this.border = new RecolorLineBorder(this.getBackground(), s);
            this.setBorder(this.border);
        }
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
        if (this.activeplaceholder) {
            this.activatePlaceholder();
        }
    }

    public Color getPlaceholderColor() {
        return this.placeholdercolor;
    }

    public Color getNonPlaceholderForeground() {
        return this.foregroundcolor;
    }

    @Override
    public void setForeground(Color fg) {
        this.foregroundcolor = fg;
        if (!this.activeplaceholder) {
            super.setForeground(fg);
        }
    }

    public void showInvalid() {
        this.showInvalid(null);
    }

    public void showInvalid(String error) {
        if (this.animtimer != null) {
            return;
        }
        String torigtext = null;
        final Color phcolor = this.placeholdercolor;
        final String ph = this.placeholder;
        if (error != null) {
            torigtext = this.getText();
            this.setPlaceholderColor(Color.BLACK);
            this.setPlaceholder(error);
            this.setText("");
        }
        final String origtext = torigtext;
        AbstractAction anim = new AbstractAction(){
            protected static final int STEPS = 35;
            protected int step = 0;
            protected double[] cc;
            protected double[] diff;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.step == 0) {
                    JPlaceholderTextField.this.origcolor = JPlaceholderTextField.this.getBackground();
                    this.cc = SGUI.colorToRgba(JPlaceholderTextField.this.invalidcolor);
                    this.diff = SGUI.colorToRgba(JPlaceholderTextField.this.origcolor);
                    int i = 0;
                    while (i < this.diff.length) {
                        int n = i;
                        this.diff[n] = this.diff[n] - this.cc[i];
                        int n2 = i++;
                        this.diff[n2] = this.diff[n2] / 34.0;
                    }
                }
                Color c = SGUI.rgbaToColor(this.cc);
                if (JPlaceholderTextField.this.border != null) {
                    JPlaceholderTextField.this.border.setColor(c);
                } else {
                    JPlaceholderTextField.this.setBackground(c);
                }
                JPlaceholderTextField.this.repaint();
                for (int i = 0; i < this.cc.length; ++i) {
                    int n = i;
                    this.cc[n] = this.cc[n] + this.diff[i];
                }
                ++this.step;
                if (this.step >= 35) {
                    ((Timer)e.getSource()).stop();
                    if (JPlaceholderTextField.this.border != null) {
                        JPlaceholderTextField.this.border.setColor(JPlaceholderTextField.this.origcolor);
                    } else {
                        JPlaceholderTextField.this.setBackground(JPlaceholderTextField.this.origcolor);
                    }
                    if (origtext != null) {
                        JPlaceholderTextField.this.setPlaceholderColor(phcolor);
                        JPlaceholderTextField.this.setPlaceholder(ph);
                        JPlaceholderTextField.this.setText(origtext);
                    }
                    JPlaceholderTextField.this.animtimer = null;
                }
            }
        };
        this.animtimer = new Timer(17, anim);
        this.animtimer.start();
    }

    public void setInvalidColor(Color invalidcolor) {
        this.invalidcolor = invalidcolor;
    }

    @Override
    public String getText() {
        if (this.activeplaceholder) {
            return "";
        }
        return super.getText();
    }

    public void setNonPlaceholderText(String t) {
        this.deactivatePlaceholder();
        this.getDocument().removeDocumentListener(this.doclistener);
        super.setText(t);
        this.getDocument().addDocumentListener(this.doclistener);
    }

    public void setPlaceholderColor(Color placeholdercolor) {
        this.placeholdercolor = placeholdercolor;
        if (this.activeplaceholder) {
            super.setForeground(placeholdercolor);
        }
    }

    protected void activatePlaceholder() {
        super.setForeground(this.placeholdercolor);
        this.activeplaceholder = true;
        this.getDocument().removeDocumentListener(this.doclistener);
        super.setText(this.placeholder);
        this.getDocument().addDocumentListener(this.doclistener);
        this.setHighlighter(null);
    }

    protected void deactivatePlaceholder() {
        super.setForeground(this.foregroundcolor);
        this.activeplaceholder = false;
        this.getDocument().removeDocumentListener(this.doclistener);
        String txt = super.getText();
        txt = txt.replace(this.placeholder, "");
        super.setText(txt);
        this.getDocument().addDocumentListener(this.doclistener);
        this.setHighlighter(this.highlighter);
    }

    protected static class RecolorLineBorder
    extends LineBorder {
        public RecolorLineBorder(Color color, int thickness) {
            super(color, thickness);
        }

        public void setColor(Color color) {
            this.lineColor = color;
        }
    }
}

