/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.Timer;

public class JBusyRing
extends JComponent {
    protected boolean active;
    protected Dimension size;
    protected Color ringcolor = Color.GRAY;
    protected long startframe = System.currentTimeMillis();
    protected ActionListener animationaction;
    protected Timer animationtimer;
    protected long fullrot = 1000L;
    protected int frametime = 17;
    protected double halfstroke = 0.1;

    public JBusyRing() {
        this.setSize(new Dimension(32, 32));
        this.setBackground(new Color(1.0f, 1.0f, 1.0f, 0.0f));
        this.animationaction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JBusyRing.this.repaint();
            }
        };
        this.animationtimer = new Timer(this.frametime, this.animationaction);
        this.setDoubleBuffered(true);
        this.animationtimer.setRepeats(true);
    }

    public void activate() {
        this.startframe = System.currentTimeMillis();
        this.active = true;
        this.animationtimer.restart();
    }

    public void deactivate() {
        this.active = false;
        this.animationtimer.stop();
        this.repaint();
    }

    public void setRingColor(Color c) {
        this.ringcolor = c;
    }

    public void setRotationsPerSecond(double rps) {
        this.fullrot = Math.round(1000.0 / rps);
    }

    public void setFramesPerSecond(double fps) {
        this.frametime = (int)Math.round(1000.0 / fps);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (!this.active) {
            return;
        }
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        double sx = Math.max(0, g2.getClipBounds().width - 2);
        double sy = Math.max(0, g2.getClipBounds().height - 2);
        long diff = System.currentTimeMillis() - this.startframe;
        double rot = (double)(diff % this.fullrot) * 360.0 / (double)this.fullrot;
        AffineTransform oldt = g2.getTransform();
        AffineTransform t = new AffineTransform(oldt);
        t.translate(1.0, 1.0);
        t.scale(sx, sy);
        g2.setTransform(t);
        double stroke = this.halfstroke + this.halfstroke;
        g2.setStroke(new BasicStroke((float)(this.halfstroke + this.halfstroke), 1, 0));
        double segs = 144.0;
        double ringsize = 270.0;
        double ringpos = 360.0 - rot;
        double segsize = ringsize / segs;
        int i = 0;
        while ((double)i < segs) {
            double finput = (double)i / segs - 1.0;
            finput *= finput;
            finput *= finput;
            int f = (int)(finput * 255.0);
            Color faded = new Color(this.ringcolor.getRed(), this.ringcolor.getGreen(), this.ringcolor.getBlue(), f);
            g2.setColor(faded);
            Arc2D.Double arc = new Arc2D.Double(0.0 + this.halfstroke, 0.0 + this.halfstroke, 1.0 - stroke, 1.0 - stroke, ringpos + segsize * (double)i, segsize, 0);
            g2.draw(arc);
            ++i;
        }
        g2.setTransform(oldt);
        g2.dispose();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.size;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.size;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.size;
    }

    @Override
    public void setSize(Dimension d) {
        this.size = d;
    }

    @Override
    public void setSize(int width, int height) {
        this.setSize(new Dimension(width, height));
    }

    protected void finalize() throws Throwable {
        if (this.animationtimer.isRunning()) {
            this.animationtimer.stop();
        }
    }
}

