/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import javax.swing.border.Border;

public class GlowBorder
implements Border {
    protected Insets insets;
    protected Color inner = Color.RED;
    protected Color outer = null;

    public GlowBorder(int top, int left, int bottom, int right) {
        this.insets = new Insets(top, left, bottom, right);
    }

    public void setInnerColor(Color inner) {
        this.inner = inner;
    }

    public void setOuterColor(Color outer) {
        this.outer = outer;
    }

    public void setOuterColorTransparent() {
        this.outer = this.inner != null ? null : new Color(1.0f, 1.0f, 1.0f, 0.0f);
    }

    public void setInnerColorTransparent() {
        this.inner = this.outer != null ? null : new Color(1.0f, 1.0f, 1.0f, 0.0f);
    }

    @Override
    public void paintBorder(Component c, Graphics gg, int xx, int yy, int width, int height) {
        Graphics2D g2 = (Graphics2D)gg;
        Color outer = this.outer == null ? new Color(this.inner.getRed(), this.inner.getGreen(), this.inner.getBlue(), 0) : this.outer;
        Color inner = this.inner == null ? new Color(outer.getRed(), outer.getGreen(), outer.getBlue(), 0) : this.inner;
        double or = (double)outer.getRed() / 255.0;
        double og = (double)outer.getGreen() / 255.0;
        double ob = (double)outer.getBlue() / 255.0;
        double oa = (double)outer.getAlpha() / 255.0;
        double ir = (double)inner.getRed() / 255.0;
        double ig = (double)inner.getGreen() / 255.0;
        double ib = (double)inner.getBlue() / 255.0;
        double ia = (double)inner.getAlpha() / 255.0;
        double lp = this.insets.left;
        double rp = width - this.insets.right;
        double tp = this.insets.top;
        double bp = height - this.insets.bottom;
        BufferedImage img = new BufferedImage(width, height, 7);
        byte[] bytes = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
        for (int y = 0; y < img.getHeight(); ++y) {
            for (int x = 0; x < img.getWidth(); ++x) {
                double r;
                double g;
                double b;
                double a;
                if (x > this.insets.left && x < width - this.insets.right && y > this.insets.top && y < height - this.insets.bottom) {
                    a = 0.0;
                    b = 0.0;
                    g = 0.0;
                    r = 0.0;
                } else {
                    double dx = 0.0;
                    double dy = 0.0;
                    if ((double)x < lp) {
                        dx = (lp - (double)x) / (double)this.insets.left;
                    } else if ((double)x > rp) {
                        dx = ((double)x - rp) / (double)this.insets.right;
                    }
                    if ((double)y < tp) {
                        dy = (tp - (double)y) / (double)this.insets.top;
                    } else if ((double)y > bp) {
                        dy = ((double)y - bp) / (double)this.insets.bottom;
                    }
                    double val = Math.min(1.0, Math.pow((dx * dx + dy * dy) / 0.5, 0.5));
                    double ival = 1.0 - val;
                    a = oa * val + ia * ival;
                    r = or * val + ir * ival;
                    g = og * val + ig * ival;
                    b = ob * val + ib * ival;
                }
                int pos = y * width + x << 2;
                bytes[pos] = (byte)(255.0 * a);
                bytes[pos + 1] = (byte)(255.0 * b);
                bytes[pos + 2] = (byte)(255.0 * g);
                bytes[pos + 3] = (byte)(255.0 * r);
            }
        }
        g2.drawImage((Image)img, xx, yy, null);
        g2.dispose();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

