/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.gui;

import jadex.commons.IFilter;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.commons.concurrent.IThreadPool;
import jadex.commons.concurrent.ThreadPool;
import jadex.commons.future.ISubscriptionIntermediateFuture;
import jadex.commons.future.ITerminationCommand;
import jadex.commons.future.IntermediateEmptyResultListener;
import jadex.commons.future.TerminableFuture;
import jadex.commons.gui.SDirScan;
import jadex.commons.gui.SGUI;
import jadex.commons.gui.future.SwingIntermediateResultListener;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIDefaults;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class ClassSearchPanel
extends JPanel {
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"class", SGUI.makeIcon(ClassSearchPanel.class, "/jadex/commons/gui/images/class.png"), "abstractclass", SGUI.makeIcon(ClassSearchPanel.class, "/jadex/commons/gui/images/abstractclass.png"), "interface", SGUI.makeIcon(ClassSearchPanel.class, "/jadex/commons/gui/images/interface.png")});
    protected JTable results;
    protected ClassTableModel ctm;
    protected JLabel status;
    protected IThreadPool tp;
    protected ClassLoader cl;
    protected String curquery;
    protected JCheckBox cbif;
    protected JCheckBox cbac;
    protected JCheckBox cbc;
    protected JCheckBox cbic;
    protected TerminableFuture<Void> lastsearch;

    public ClassSearchPanel(ClassLoader cl, IThreadPool tp) {
        this(cl, tp, true, true, true, false);
    }

    public ClassSearchPanel(ClassLoader cl, IThreadPool tp, boolean interfaces, boolean absclasses, boolean classes, boolean innerclasses) {
        this.tp = tp == null ? new ThreadPool() : tp;
        final JTextField tfsearch = new JTextField();
        tfsearch.addKeyListener(new KeyListener(){
            protected boolean dirty = false;
            protected Timer t = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (dirty) {
                        dirty = false;
                    } else {
                        t.stop();
                        ClassSearchPanel.this.performSearch(tfsearch.getText());
                    }
                }
            });

            @Override
            public void keyTyped(KeyEvent e) {
                if (!this.t.isRunning()) {
                    this.t.start();
                } else {
                    this.dirty = true;
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.status = new JLabel("idle");
        this.ctm = new ClassTableModel();
        this.results = new JTable(this.ctm);
        this.results.setDefaultRenderer(ClassInfo.class, new ClassCellRenderer());
        this.results.setTableHeader(null);
        this.cbif = new JCheckBox("Interfaces", interfaces);
        this.cbac = new JCheckBox("Abstract Classes", absclasses);
        this.cbc = new JCheckBox("Classes", classes);
        this.cbic = new JCheckBox("Inner Classes", innerclasses);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassSearchPanel.this.performSearch(tfsearch.getText());
            }
        };
        this.cbif.addActionListener(al);
        this.cbac.addActionListener(al);
        this.cbc.addActionListener(al);
        this.cbic.addActionListener(al);
        JPanel cbp = new JPanel(new FlowLayout(0));
        cbp.add(this.cbif);
        cbp.add(this.cbac);
        cbp.add(this.cbc);
        cbp.add(this.cbic);
        this.setLayout(new GridBagLayout());
        int y = 0;
        this.add((Component)new JLabel("Enter type name prefix:"), new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 18, 3, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)tfsearch, new GridBagConstraints(0, y++, 2, 1, 1.0, 0.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)cbp, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 18, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)new JLabel("Search Results:"), new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 18, 3, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)new JScrollPane(this.results), new GridBagConstraints(0, y++, 2, 1, 1.0, 1.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.status, new GridBagConstraints(0, y++, 2, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.performSearch(null);
    }

    public IThreadPool getThreadPool() {
        return this.tp;
    }

    protected synchronized void setCurrentQuery(String curquery) {
        this.curquery = curquery;
    }

    protected synchronized boolean isCurrentQuery(String curquery) {
        return SUtil.equals((Object)this.curquery, (Object)curquery);
    }

    public void performSearch(final String exp) {
        TerminableFuture ret;
        assert (SwingUtilities.isEventDispatchThread());
        final ISubscriptionIntermediateFuture[] fut = new ISubscriptionIntermediateFuture[1];
        if (this.lastsearch != null) {
            this.lastsearch.terminate();
        }
        this.lastsearch = ret = new TerminableFuture(new ITerminationCommand(){

            public void terminated(Exception reason) {
                if (fut[0] != null) {
                    fut[0].terminate();
                }
            }

            public boolean checkTermination(Exception reason) {
                return true;
            }
        });
        if (exp == null || exp.length() == 0) {
            this.status.setText("idle");
            this.lastsearch.setResultIfUndone(null);
            return;
        }
        final Pattern pat = SUtil.createRegexFromGlob((String)(exp + "*"));
        this.setCurrentQuery(exp);
        if (exp != null && exp.length() > 0) {
            this.status.setText("searching '" + exp + "'");
        }
        this.getThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                IFilter<Object> filefilter = new IFilter<Object>(){

                    public boolean filter(Object obj) {
                        String fn = "";
                        if (obj instanceof File) {
                            File f = (File)obj;
                            fn = f.getName();
                        } else if (obj instanceof JarEntry) {
                            JarEntry je = (JarEntry)obj;
                            fn = je.getName();
                        }
                        if (!ClassSearchPanel.this.cbic.isSelected() && fn.indexOf("$") != -1) {
                            return false;
                        }
                        StringTokenizer stok = new StringTokenizer(exp, "*?");
                        boolean ret = true;
                        while (ret && stok.hasMoreElements()) {
                            String tst = stok.nextToken();
                            ret = fn.indexOf(tst) != -1;
                        }
                        return ret;
                    }
                };
                IFilter classfilter = new IFilter<Class<?>>(){

                    public boolean filter(Class<?> clazz) {
                        boolean ret;
                        boolean in = clazz.isInterface();
                        boolean abs = Modifier.isAbstract(clazz.getModifiers());
                        boolean bl = ret = in && ClassSearchPanel.this.cbif.isSelected() || !in && abs && ClassSearchPanel.this.cbac.isSelected() || !in && !abs && ClassSearchPanel.this.cbc.isSelected();
                        if (ret) {
                            String clname = SReflect.getInnerClassName(clazz);
                            if (exp.indexOf("*") == -1 && exp.indexOf("?") == -1) {
                                ret = clname.startsWith(exp);
                            } else {
                                Matcher m = pat.matcher(clname);
                                ret = m.matches();
                            }
                        }
                        return ret;
                    }
                };
                fut[0] = SDirScan.asyncScanForClasses(ClassSearchPanel.this.cl, filefilter, classfilter, -1, true);
                fut[0].addResultListener(new SwingIntermediateResultListener(new IntermediateEmptyResultListener<Class<?>>(){
                    List<Class<?>> res = new ArrayList();

                    public void intermediateResultAvailable(Class<?> result) {
                        if (!ret.isDone()) {
                            this.res.add(result);
                        }
                    }

                    public void finished() {
                        if (!ret.isDone()) {
                            ClassSearchPanel.this.ctm.clear();
                            for (Class<?> cl : this.res) {
                                ClassSearchPanel.this.ctm.addEntry(cl);
                            }
                            if (ClassSearchPanel.this.ctm.size() > 0) {
                                ClassSearchPanel.this.results.changeSelection(0, 0, false, false);
                                ClassSearchPanel.this.results.requestFocus();
                            }
                            ClassSearchPanel.this.status.setText("searching '" + exp + "' (" + ClassSearchPanel.this.ctm.size() + ") finished");
                            ret.setResultIfUndone(null);
                        }
                    }

                    public void resultAvailable(Collection<Class<?>> result) {
                        for (Class<?> clazz : result) {
                            ClassSearchPanel.this.ctm.addEntry(clazz);
                        }
                        this.finished();
                    }

                    public void exceptionOccurred(Exception exception) {
                        ClassSearchPanel.this.status.setText("idle '" + exp + "'");
                        ClassSearchPanel.this.lastsearch.setExceptionIfUndone(exception);
                    }
                }));
            }
        });
    }

    protected void setStatus(final String text) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.status.setText(text);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClassSearchPanel.this.status.setText(text);
                }
            });
        }
    }

    public Class<?> getSelectedClass() {
        Class ret = null;
        int sel = this.results.getSelectedRow();
        if (sel > 0) {
            ClassInfo ci = this.ctm.getClass(sel);
            ret = SReflect.findClass0((String)(ci.getPkg() + "." + ci.getName()), null, (ClassLoader)this.cl);
        }
        return ret;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Class<?> cl = ClassSearchPanel.showDialog(null, null, null);
                System.out.println("clazz: " + cl);
            }
        });
    }

    public static Class<?> showDialog(ClassLoader cl, IThreadPool tp, Component parent) {
        assert (SwingUtilities.isEventDispatchThread());
        Class<?> ret = null;
        ClassSearchPanel pan = new ClassSearchPanel(cl, (IThreadPool)(tp != null ? tp : new ThreadPool()));
        final JDialog dia = new JDialog((Frame)null, "Type Selection", true);
        JButton bok = new JButton("OK");
        JButton bcancel = new JButton("Cancel");
        bok.setMinimumSize(bcancel.getMinimumSize());
        bok.setPreferredSize(bcancel.getPreferredSize());
        JPanel ps = new JPanel(new GridBagLayout());
        ps.add((Component)bok, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 14, 3, new Insets(2, 2, 2, 2), 0, 0));
        ps.add((Component)bcancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 14, 1, new Insets(2, 2, 2, 2), 0, 0));
        dia.getContentPane().add((Component)pan, "Center");
        dia.getContentPane().add((Component)ps, "South");
        final boolean[] ok = new boolean[1];
        bok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ok[0] = true;
                dia.dispose();
            }
        });
        bcancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dia.dispose();
            }
        });
        pan.results.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "Enter");
        pan.results.getActionMap().put("Enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ok[0] = true;
                dia.dispose();
            }
        });
        dia.pack();
        dia.setLocation(SGUI.calculateMiddlePosition(parent != null ? SGUI.getWindowParent(parent) : null, dia));
        dia.setVisible(true);
        if (ok[0]) {
            ret = pan.getSelectedClass();
        }
        return ret;
    }

    static class ClassInfo {
        protected String name;
        protected String pkg;
        protected Type type;

        public ClassInfo(Class<?> clazz) {
            this.name = SReflect.getUnqualifiedClassName(clazz);
            this.pkg = clazz.getPackage().getName();
            this.type = clazz.isInterface() ? Type.INTERFACE : (Modifier.isAbstract(clazz.getModifiers()) ? Type.ABSTRACTCLASS : Type.CLASS);
        }

        public ClassInfo(String name, Type type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public String getPkg() {
            return this.pkg;
        }

        public void setPkg(String pkg) {
            this.pkg = pkg;
        }

        public static enum Type {
            INTERFACE,
            ABSTRACTCLASS,
            CLASS;

        }
    }

    static class ClassCellRenderer
    extends DefaultTableCellRenderer {
        ClassCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ClassInfo clazz = (ClassInfo)value;
            int sel = table.getSelectedRow();
            String clname = SReflect.getUnqualifiedTypeName((String)clazz.getName());
            Object val = sel == row ? clname + " - " + clazz.getPkg() : clname;
            if (clazz.getType().equals((Object)ClassInfo.Type.INTERFACE)) {
                this.setIcon(icons.getIcon("interface"));
            } else if (clazz.getType().equals((Object)ClassInfo.Type.ABSTRACTCLASS)) {
                this.setIcon(icons.getIcon("abstractclass"));
            } else {
                this.setIcon(icons.getIcon("class"));
            }
            return super.getTableCellRendererComponent(table, val, isSelected, hasFocus, row, column);
        }
    }

    class ClassTableModel
    extends AbstractTableModel {
        protected List<ClassInfo> entries;

        ClassTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        public void addEntry(Class<?> clazz) {
            if (this.entries == null) {
                this.entries = new ArrayList<ClassInfo>();
            }
            ClassInfo ci = new ClassInfo(clazz);
            int done = -1;
            int cnt = this.entries.size();
            if (cnt > 0) {
                for (int i = 0; i < cnt && done == -1; ++i) {
                    ClassInfo tmp = this.entries.get(i);
                    if (tmp.getName().compareTo(ci.getName()) < 0) continue;
                    this.entries.add(i, ci);
                    done = i;
                }
            }
            if (done == -1) {
                this.entries.add(ci);
                done = this.entries.size() - 1;
            }
            this.fireTableRowsInserted(done, done);
        }

        @Override
        public int getRowCount() {
            return this.entries != null ? this.entries.size() : 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ClassInfo ret = null;
            if (this.entries != null && rowIndex > -1 && rowIndex < this.entries.size() && columnIndex == 0) {
                ret = this.entries.get(rowIndex);
            }
            return ret;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return "Name";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return ClassInfo.class;
        }

        public ClassInfo getClass(int i) {
            return this.entries != null ? this.entries.get(i) : null;
        }

        public void clear() {
            if (this.entries != null && !this.entries.isEmpty()) {
                int size = this.entries.size();
                this.entries.clear();
                this.fireTableRowsDeleted(0, size - 1);
            }
        }

        public int size() {
            return this.entries != null ? this.entries.size() : 0;
        }
    }
}

