/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.future;

import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.ITuple2Future;
import jadex.commons.future.ITuple2ResultListener;
import jadex.commons.future.IntermediateFuture;
import jadex.commons.future.ThreadSuspendable;
import jadex.commons.future.TupleResult;
import java.util.Arrays;

public class Tuple2Future<E, F>
extends IntermediateFuture<TupleResult>
implements ITuple2Future<E, F> {
    public Tuple2Future() {
    }

    public Tuple2Future(E result1, F result2) {
        super(Arrays.asList(new TupleResult(0, result1), new TupleResult(1, result2)));
    }

    public Tuple2Future(Exception exception) {
        super(exception);
    }

    @Override
    public E getFirstResult(ThreadSuspendable sus) {
        return this.getFirstResult(-2L);
    }

    @Override
    public E getFirstResult() {
        return this.getFirstResult(-2L);
    }

    @Override
    public F getSecondResult() {
        return this.getSecondResult(-2L);
    }

    @Override
    public E getFirstResult(long timeout) {
        return this.getFirstResult(timeout, false);
    }

    @Override
    public F getSecondResult(long timeout) {
        return this.getSecondResult(-2L, false);
    }

    @Override
    public E getFirstResult(long timeout, boolean realtime) {
        return (E)this.getXResult(0, timeout, realtime);
    }

    @Override
    public F getSecondResult(long timeout, boolean realtime) {
        return (F)this.getXResult(1, timeout, realtime);
    }

    public void setFirstResult(E result) {
        this.setXResult(0, result);
    }

    public void setSecondResult(F result) {
        this.setXResult(1, result);
    }

    public void setFirstResultIfUndone(E result) {
        this.setXResultIfUndone(0, result);
    }

    public void setSecondResultIfUndone(F result) {
        this.setXResultIfUndone(1, result);
    }

    protected void setXResult(int idx, Object res) {
        this.addIntermediateResult(new TupleResult(idx, res));
        if (this.results.size() == this.getMax()) {
            this.setFinishedIfUndone();
        }
    }

    protected void setXResultIfUndone(int idx, Object res) {
        this.addIntermediateResultIfUndone(new TupleResult(idx, res));
        if (this.results.size() == this.getMax()) {
            this.setFinishedIfUndone();
        }
    }

    protected Object getXResult(int idx, long timeout, boolean realtime) {
        TupleResult res = null;
        for (int i = 0; i < this.getMax() && res == null; ++i) {
            res = this.findResult(idx);
            if (res != null || (res = (TupleResult)this.getNextIntermediateResult(timeout, realtime)).getNum() == idx) continue;
            res = null;
        }
        return res.getResult();
    }

    protected synchronized TupleResult findResult(int idx) {
        TupleResult ret = null;
        if (this.results != null && this.results.size() > 0) {
            for (TupleResult res : this.results) {
                if (res.getNum() != idx) continue;
                ret = res;
            }
        }
        return ret;
    }

    protected int getMax() {
        return 2;
    }

    @Override
    protected void notifyIntermediateResult(IIntermediateResultListener<TupleResult> listener, TupleResult result) {
        if (listener instanceof ITuple2ResultListener) {
            ITuple2ResultListener lis = (ITuple2ResultListener)listener;
            if (result.getNum() == 0) {
                lis.firstResultAvailable(result.getResult());
            } else {
                lis.secondResultAvailable(result.getResult());
            }
        } else {
            super.notifyIntermediateResult(listener, result);
        }
    }
}

