/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.future;

import jadex.commons.SUtil;
import jadex.commons.TimeoutException;
import jadex.commons.concurrent.ThreadPool;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.ISuspendable;
import jadex.commons.future.ThreadLocalTransferHelper;

public class ThreadSuspendable
extends ThreadLocalTransferHelper
implements ISuspendable {
    protected IFuture<?> future;
    protected boolean resumed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspend(Future<?> future, long timeout, boolean realtime) {
        if (timeout == -2L) {
            timeout = this.getDefaultTimeout();
        }
        long endtime = timeout > 0L ? System.currentTimeMillis() + timeout : -1L;
        ThreadSuspendable threadSuspendable = this;
        synchronized (threadSuspendable) {
            this.future = future;
            this.resumed = false;
            assert (!ThreadPool.WAITING_THREADS.containsKey(Thread.currentThread()));
            ThreadPool.WAITING_THREADS.put(Thread.currentThread(), future);
            try {
                long waittime = endtime - System.currentTimeMillis();
                while (!(this.resumed || endtime != -1L && waittime <= 0L)) {
                    if (endtime == -1L) {
                        this.wait();
                    } else {
                        this.wait(waittime);
                    }
                    waittime = endtime - System.currentTimeMillis();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            finally {
                assert (ThreadPool.WAITING_THREADS.get(Thread.currentThread()) == future);
                ThreadPool.WAITING_THREADS.remove(Thread.currentThread());
                this.afterSwitch();
                this.future = null;
            }
            if (!this.resumed) {
                if (timeout > 0L) {
                    throw new TimeoutException("Timeout: " + timeout + ", realtime=" + realtime);
                }
                throw new IllegalStateException("Future.wait() returned unexpectedly. Timeout: " + timeout + ", realtime=" + realtime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume(Future<?> future) {
        ThreadSuspendable threadSuspendable = this;
        synchronized (threadSuspendable) {
            if (future == this.future) {
                this.resumed = true;
                this.beforeSwitch();
                this.notify();
            }
        }
    }

    @Override
    public Object getMonitor() {
        return this;
    }

    protected long getDefaultTimeout() {
        return SUtil.DEFTIMEOUT;
    }
}

