/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.future;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ThreadLocalTransferHelper {
    protected static final Set<ThreadLocal<Object>> THREADLOCALS = Collections.synchronizedSet(new HashSet());
    protected Map<ThreadLocal<Object>, Object> vals;

    public static Map<ThreadLocal<Object>, Object> saveValues() {
        HashMap<ThreadLocal<Object>, Object> ret = null;
        if (THREADLOCALS.size() > 0) {
            ret = new HashMap<ThreadLocal<Object>, Object>();
            for (ThreadLocal<Object> tl : THREADLOCALS) {
                ret.put(tl, tl.get());
            }
        }
        return ret;
    }

    public static void restoreValues(Map<ThreadLocal<Object>, Object> vals) {
        if (vals != null) {
            for (Map.Entry<ThreadLocal<Object>, Object> entry : vals.entrySet()) {
                entry.getKey().set(entry.getValue());
            }
        }
    }

    public static void addThreadLocal(ThreadLocal<?> tl) {
        THREADLOCALS.add(tl);
    }

    public static void removeThreadLocal(ThreadLocal<?> tl) {
        THREADLOCALS.remove(tl);
    }

    public ThreadLocalTransferHelper() {
    }

    public ThreadLocalTransferHelper(boolean beforeswitch) {
        if (beforeswitch) {
            this.beforeSwitch();
        }
    }

    public void beforeSwitch() {
        this.vals = ThreadLocalTransferHelper.saveValues();
    }

    public void afterSwitch() {
        ThreadLocalTransferHelper.restoreValues(this.vals);
    }
}

