/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.future;

import jadex.commons.ICommand;
import jadex.commons.IFilter;
import jadex.commons.future.Future;
import jadex.commons.future.FutureTerminatedException;
import jadex.commons.future.ITerminableFuture;
import jadex.commons.future.ITerminationCommand;
import java.util.LinkedHashMap;
import java.util.Map;

public class TerminableFuture<E>
extends Future<E>
implements ITerminableFuture<E> {
    protected ITerminationCommand terminate;
    protected Map<ICommand<Object>, IFilter<Object>> bcommands;

    public TerminableFuture() {
    }

    public TerminableFuture(ITerminationCommand terminate) {
        this.terminate = terminate;
    }

    @Override
    public void terminate() {
        this.terminate(new FutureTerminatedException());
    }

    @Override
    public void terminate(Exception reason) {
        boolean term;
        boolean bl = term = this.terminate == null || this.terminate.checkTermination(reason);
        if (term && this.setExceptionIfUndone(reason) && this.terminate != null) {
            this.terminate.terminated(reason);
        }
    }

    @Override
    public void sendBackwardCommand(Object info) {
        if (this.bcommands != null) {
            for (Map.Entry<ICommand<Object>, IFilter<Object>> entry : this.bcommands.entrySet()) {
                IFilter<Object> fil = entry.getValue();
                if (fil != null && !fil.filter(info)) continue;
                ICommand<Object> com = entry.getKey();
                com.execute(info);
            }
        }
    }

    public void addBackwardCommand(IFilter<Object> filter, ICommand<Object> command) {
        if (this.bcommands == null) {
            this.bcommands = new LinkedHashMap<ICommand<Object>, IFilter<Object>>();
        }
        this.bcommands.put(command, filter);
    }

    public void removeBackwardCommand(ICommand<Object> command) {
        if (this.bcommands != null) {
            this.bcommands.remove(command);
        }
    }

    public void setTerminationCommand(ITerminationCommand terminate) {
        this.terminate = terminate;
    }
}

