/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.future;

import jadex.commons.future.FutureTerminatedException;
import jadex.commons.future.IPullIntermediateFuture;
import jadex.commons.future.ITerminableFuture;
import java.util.ArrayList;
import java.util.List;

public class TerminableDelegationFutureHandler<E> {
    protected ITerminableFuture<E> src;
    protected boolean terminate;
    protected boolean terminated;
    protected Exception reason;
    protected List<Object> storedcmds;
    protected int pullcnt;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTerminationSource(ITerminableFuture<E> src) {
        List<Object> mycmds;
        boolean myterminate;
        TerminableDelegationFutureHandler terminableDelegationFutureHandler = this;
        synchronized (terminableDelegationFutureHandler) {
            if (this.src != null) {
                throw new IllegalStateException("Source already set: " + this);
            }
            this.src = src;
            myterminate = this.terminate && !this.terminated;
            this.terminated = this.terminated || myterminate;
            this.pullcnt = 0;
            mycmds = this.storedcmds;
            this.storedcmds = null;
        }
        if (myterminate) {
            src.terminate(this.reason);
        } else {
            int mypull;
            if (mypull > 0) {
                IPullIntermediateFuture pull = (IPullIntermediateFuture)src;
                for (mypull = this.pullcnt; mypull > 0; --mypull) {
                    pull.pullIntermediateResult();
                }
            }
            if (mycmds != null) {
                for (Object e : mycmds) {
                    src.sendBackwardCommand(e);
                }
            }
        }
    }

    public void terminate() {
        this.terminate(new FutureTerminatedException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate(Exception reason) {
        boolean mynotify;
        TerminableDelegationFutureHandler terminableDelegationFutureHandler = this;
        synchronized (terminableDelegationFutureHandler) {
            if (this.terminated || this.terminate) {
                throw new IllegalStateException("Already terminated: " + this);
            }
            this.terminate = true;
            this.reason = reason;
            this.terminated = mynotify = this.src != null;
        }
        if (mynotify) {
            this.src.terminate(reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pullIntermediateResult() {
        int mypull = 0;
        TerminableDelegationFutureHandler terminableDelegationFutureHandler = this;
        synchronized (terminableDelegationFutureHandler) {
            ++this.pullcnt;
            if (this.src != null) {
                mypull = this.pullcnt;
                this.pullcnt = 0;
            }
        }
        if (mypull > 0) {
            IPullIntermediateFuture pull = (IPullIntermediateFuture)this.src;
            while (mypull > 0) {
                pull.pullIntermediateResult();
                --mypull;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBackwardCommand(Object info) {
        boolean send;
        TerminableDelegationFutureHandler terminableDelegationFutureHandler = this;
        synchronized (terminableDelegationFutureHandler) {
            boolean bl = send = this.src != null;
            if (!send) {
                if (this.storedcmds == null) {
                    this.storedcmds = new ArrayList<Object>();
                }
                this.storedcmds.add(info);
            }
        }
        if (send) {
            this.src.sendBackwardCommand(info);
        }
    }
}

