/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.future;

import jadex.commons.future.Future;
import jadex.commons.future.IIntermediateFuture;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ISubscriptionIntermediateFuture;
import jadex.commons.future.ISuspendable;
import jadex.commons.future.ITerminationCommand;
import jadex.commons.future.IntermediateEmptyResultListener;
import jadex.commons.future.TerminableIntermediateFuture;
import jadex.commons.future.ThreadSuspendable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

public class SubscriptionIntermediateFuture<E>
extends TerminableIntermediateFuture<E>
implements ISubscriptionIntermediateFuture<E> {
    protected Map<Thread, List<E>> ownresults;
    protected boolean storeforfirst;
    protected int resultssize;

    public SubscriptionIntermediateFuture() {
        this((ITerminationCommand)null);
    }

    public SubscriptionIntermediateFuture(Exception exception) {
        super(exception);
    }

    public SubscriptionIntermediateFuture(ITerminationCommand terminate) {
        this(terminate, true);
    }

    public SubscriptionIntermediateFuture(ITerminationCommand terminate, boolean storeforfirst) {
        super(terminate);
        this.storeforfirst = storeforfirst;
    }

    @Override
    protected void storeResult(E result, boolean scheduled) {
        ++this.resultssize;
        if (this.storeforfirst) {
            super.storeResult(result, scheduled);
        } else if (!scheduled && this.ownresults == null) {
            throw new RuntimeException("lost value: " + result);
        }
        if (this.ownresults != null) {
            for (List<E> res : this.ownresults.values()) {
                res.add(result);
            }
        }
        this.resumeIntermediate();
    }

    @Override
    protected int getResultCount() {
        return this.resultssize;
    }

    @Override
    public void addQuietListener(IResultListener<Collection<E>> listener) {
        if (!(listener instanceof IIntermediateResultListener)) {
            throw new IllegalArgumentException("Subscription futures require intermediate listeners.");
        }
        super.addResultListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResultListener(IResultListener<Collection<E>> listener) {
        boolean first;
        if (!(listener instanceof IIntermediateResultListener)) {
            throw new IllegalArgumentException("Subscription futures require intermediate listeners.");
        }
        super.addResultListener(listener);
        SubscriptionIntermediateFuture subscriptionIntermediateFuture = this;
        synchronized (subscriptionIntermediateFuture) {
            first = this.storeforfirst;
            this.storeforfirst = false;
        }
        if (first) {
            this.results = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<E> getIntermediateResults() {
        List<Object> ret;
        SubscriptionIntermediateFuture subscriptionIntermediateFuture = this;
        synchronized (subscriptionIntermediateFuture) {
            ret = this.storeforfirst ? this.results : (this.ownresults != null ? this.ownresults.get(Thread.currentThread()) : null);
        }
        return ret != null ? ret : Collections.emptyList();
    }

    @Override
    public E getNextIntermediateResult(long timeout, boolean realtime) {
        return this.doGetNextIntermediateResult(0, timeout, realtime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNextIntermediateResult(long timeout, boolean realtime) {
        boolean suspend;
        boolean ret;
        ISuspendable caller = ISuspendable.SUSPENDABLE.get();
        if (caller == null) {
            caller = new ThreadSuspendable();
        }
        SubscriptionIntermediateFuture subscriptionIntermediateFuture = this;
        synchronized (subscriptionIntermediateFuture) {
            List<E> ownres;
            if (this.storeforfirst) {
                this.storeforfirst = false;
                ownres = this.results;
                this.results = null;
            } else {
                List<E> list = ownres = this.ownresults != null ? this.ownresults.get(Thread.currentThread()) : null;
            }
            if (ownres == null) {
                ownres = new LinkedList();
            }
            if (this.ownresults == null || !this.ownresults.containsKey(Thread.currentThread())) {
                this.ownresults = this.ownresults != null ? this.ownresults : new HashMap<Thread, List<E>>();
                this.ownresults.put(Thread.currentThread(), ownres);
            }
            ret = !ownres.isEmpty() || this.isDone() && this.getException() != null;
            boolean bl = suspend = !ret && !this.isDone();
            if (suspend) {
                if (this.icallers == null) {
                    this.icallers = Collections.synchronizedMap(new HashMap());
                }
                this.icallers.put(caller, "queued");
            }
        }
        if (suspend) {
            Object mon;
            Object object = mon = caller.getMonitor() != null ? caller.getMonitor() : caller;
            synchronized (object) {
                Object state = this.icallers.get(caller);
                if ("queued".equals(state)) {
                    this.icallers.put(caller, "suspended");
                    caller.suspend(this, timeout, realtime);
                    this.icallers.remove(caller);
                }
            }
            ret = this.hasNextIntermediateResult(timeout, realtime);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected E doGetNextIntermediateResult(int index, long timeout, boolean realtime) {
        Object mon;
        E ret = null;
        boolean suspend = false;
        ISuspendable caller = ISuspendable.SUSPENDABLE.get();
        if (caller == null) {
            caller = new ThreadSuspendable();
        }
        SubscriptionIntermediateFuture subscriptionIntermediateFuture = this;
        synchronized (subscriptionIntermediateFuture) {
            List<E> ownres;
            if (this.storeforfirst) {
                this.storeforfirst = false;
                ownres = this.results;
                this.results = null;
            } else {
                List<E> list = ownres = this.ownresults != null ? this.ownresults.get(Thread.currentThread()) : null;
            }
            if (ownres == null) {
                ownres = new LinkedList();
            }
            if (this.ownresults == null || !this.ownresults.containsKey(Thread.currentThread())) {
                this.ownresults = this.ownresults != null ? this.ownresults : new HashMap<Thread, List<E>>();
                this.ownresults.put(Thread.currentThread(), ownres);
            }
            if (!ownres.isEmpty()) {
                ret = ownres.remove(0);
            } else if (this.isDone()) {
                if (this.getException() == null) throw new NoSuchElementException("No more intermediate results.");
                SubscriptionIntermediateFuture.throwException(this.getException());
            } else {
                suspend = true;
                if (this.icallers == null) {
                    this.icallers = Collections.synchronizedMap(new HashMap());
                }
                this.icallers.put(caller, "queued");
            }
        }
        if (!suspend) return ret;
        Object object = mon = caller.getMonitor() != null ? caller.getMonitor() : caller;
        synchronized (object) {
            Object state = this.icallers.get(caller);
            if ("queued".equals(state)) {
                this.icallers.put(caller, "suspended");
                caller.suspend(this, timeout, realtime);
                this.icallers.remove(caller);
            }
        }
        ret = this.doGetNextIntermediateResult(index, timeout, realtime);
        return ret;
    }

    @Override
    public IIntermediateFuture<E> catchEx(final Consumer<? super Exception> consumer, Class<?> futuretype) {
        IntermediateEmptyResultListener reslis = new IntermediateEmptyResultListener(){

            @Override
            public void exceptionOccurred(Exception exception) {
                consumer.accept(exception);
            }
        };
        this.addQuietListener(reslis);
        return this;
    }

    @Override
    public <T> IIntermediateFuture<E> catchEx(final Future<T> delegate) {
        IntermediateEmptyResultListener reslis = new IntermediateEmptyResultListener(){

            @Override
            public void exceptionOccurred(Exception exception) {
                delegate.setException(exception);
            }
        };
        this.addQuietListener(reslis);
        return this;
    }

    @Override
    public IIntermediateFuture<? extends E> max(final Consumer<Integer> function) {
        this.addQuietListener(new IntermediateEmptyResultListener<E>(){

            @Override
            public void maxResultCountAvailable(int max) {
                function.accept(max);
            }
        });
        return this;
    }

    @Override
    public IIntermediateFuture<? extends E> finished(final Consumer<Void> function) {
        this.addQuietListener(new IntermediateEmptyResultListener<E>(){

            @Override
            public void finished() {
                function.accept(null);
            }
        });
        return this;
    }
}

