/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.future;

import jadex.commons.ICommand;
import jadex.commons.future.DuplicateResultException;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IIntermediateFuture;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ISuspendable;
import jadex.commons.future.IUndoneIntermediateResultListener;
import jadex.commons.future.IntermediateDelegationResultListener;
import jadex.commons.future.IntermediateEmptyResultListener;
import jadex.commons.future.ThreadSuspendable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class IntermediateFuture<E>
extends Future<Collection<E>>
implements IIntermediateFuture<E> {
    protected List<E> results;
    protected boolean intermediate;
    protected Map<ISuspendable, String> icallers;
    protected Map<Thread, Integer> indices;
    protected int maxresultcnt = -1;
    protected ICommand<IResultListener<Collection<E>>> notcommand = new ICommand<IResultListener<Collection<E>>>(){

        public void execute(IResultListener<Collection<E>> listener) {
            if (IntermediateFuture.this.exception == null && listener instanceof IIntermediateResultListener) {
                if (!IntermediateFuture.this.intermediate && IntermediateFuture.this.results != null) {
                    for (Object result : IntermediateFuture.this.results) {
                        IntermediateFuture.this.notifyIntermediateResult((IIntermediateResultListener)listener, result);
                    }
                }
                if (IntermediateFuture.this.undone && listener instanceof IUndoneIntermediateResultListener) {
                    ((IUndoneIntermediateResultListener)listener).finishedIfUndone();
                } else {
                    ((IIntermediateResultListener)listener).finished();
                }
            } else {
                IntermediateFuture.super.getNotificationCommand().execute(listener);
            }
        }
    };

    public IntermediateFuture() {
    }

    public IntermediateFuture(Collection<E> results) {
        super(results);
    }

    public IntermediateFuture(Exception exception) {
        super(exception);
    }

    @Override
    public synchronized Collection<E> getIntermediateResults() {
        List ret = this.results != null ? new ArrayList(this.results) : Collections.emptyList();
        return ret;
    }

    public void addIntermediateResult(E result) {
        this.doAddIntermediateResult(result, false);
        this.resumeIntermediate();
    }

    public boolean addIntermediateResultIfUndone(E result) {
        boolean ret = this.doAddIntermediateResult(result, true);
        if (ret) {
            this.resumeIntermediate();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected boolean doAddIntermediateResult(final E result, boolean undone) {
        boolean ret = true;
        boolean notify = false;
        IntermediateFuture intermediateFuture = this;
        // MONITORENTER : intermediateFuture
        if (undone) {
            this.undone = true;
        }
        if (this.isDone()) {
            if (!undone) {
                if (this.exception == null) throw new DuplicateResultException(1, this, this.result, result);
                throw new DuplicateResultException(3, this, this.exception, result);
            }
            ret = false;
        } else {
            boolean scheduled = this.scheduleNotification(listener -> listener instanceof IIntermediateResultListener, new ICommand<IResultListener<Collection<E>>>(){

                public void execute(IResultListener<Collection<E>> listener) {
                    IntermediateFuture.this.notifyIntermediateResult((IIntermediateResultListener)listener, result);
                }
            });
            this.storeResult(result, scheduled);
            notify = true;
        }
        // MONITOREXIT : intermediateFuture
        if (!notify) return ret;
        IntermediateFuture.startScheduledNotifications();
        return ret;
    }

    protected void storeResult(E result, boolean scheduled) {
        this.intermediate = true;
        if (this.results == null) {
            this.results = new ArrayList();
        }
        this.results.add(result);
        if (this.maxresultcnt == this.getResultCount()) {
            this.setFinishedIfUndone();
        }
    }

    @Override
    protected synchronized boolean doSetResult(Collection<E> result, boolean undone) {
        if (this.intermediate) {
            throw new RuntimeException("setResult() only allowed without intermediate results: " + this.results);
        }
        boolean ret = super.doSetResult(result, undone);
        if (ret) {
            this.results = result != null ? new ArrayList<E>(result) : null;
        }
        return ret;
    }

    public void setFinished() {
        this.doSetFinished(false);
        this.resume();
    }

    public boolean setFinishedIfUndone() {
        boolean ret = this.doSetFinished(true);
        if (ret) {
            this.resume();
        }
        return ret;
    }

    protected synchronized boolean doSetFinished(boolean undone) {
        Collection<E> res = this.getIntermediateResults();
        boolean ret = super.doSetResult(res, undone);
        if (ret && this.results == null) {
            this.results = Collections.emptyList();
        }
        return ret;
    }

    @Override
    protected boolean doSetException(Exception exception, boolean undone) {
        return super.doSetException(exception, undone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResultListener(IResultListener<Collection<E>> listener) {
        boolean notify_finished;
        if (listener == null) {
            throw new RuntimeException();
        }
        boolean notify_intermediate = false;
        IntermediateFuture intermediateFuture = this;
        synchronized (intermediateFuture) {
            notify_finished = this.doAddResultListener(listener);
            if (this.intermediate && listener instanceof IIntermediateResultListener) {
                IIntermediateResultListener lis = (IIntermediateResultListener)listener;
                notify_intermediate = this.scheduleMaxNotification(lis);
                if (this.results != null && !this.results.isEmpty()) {
                    notify_intermediate = true;
                    for (final E result : this.results) {
                        ICommand c = new ICommand<IIntermediateResultListener<E>>(){

                            public void execute(IIntermediateResultListener<E> listener) {
                                IntermediateFuture.this.notifyIntermediateResult(listener, result);
                            }
                        };
                        this.scheduleNotification(lis, c);
                    }
                }
            }
            if (notify_finished) {
                this.scheduleNotification(listener, this.getNotificationCommand());
            }
        }
        if (notify_intermediate || notify_finished) {
            IntermediateFuture.startScheduledNotifications();
        }
    }

    @Override
    protected ICommand<IResultListener<Collection<E>>> getNotificationCommand() {
        return this.notcommand;
    }

    @Override
    public boolean hasNextIntermediateResult() {
        return this.hasNextIntermediateResult(-2L, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNextIntermediateResult(long timeout, boolean realtime) {
        boolean suspend;
        boolean ret;
        ISuspendable caller = ISuspendable.SUSPENDABLE.get();
        if (caller == null) {
            caller = new ThreadSuspendable();
        }
        IntermediateFuture intermediateFuture = this;
        synchronized (intermediateFuture) {
            Integer index;
            Integer n = index = this.indices != null ? this.indices.get(Thread.currentThread()) : null;
            if (index == null) {
                index = 0;
            }
            ret = this.results != null && this.results.size() > index || this.isDone() && this.getException() != null;
            boolean bl = suspend = !ret && !this.isDone();
            if (suspend) {
                if (this.icallers == null) {
                    this.icallers = Collections.synchronizedMap(new HashMap());
                }
                this.icallers.put(caller, "queued");
            }
        }
        if (suspend) {
            Object mon;
            Object object = mon = caller.getMonitor() != null ? caller.getMonitor() : caller;
            synchronized (object) {
                String state = this.icallers.get(caller);
                if ("queued".equals(state)) {
                    this.icallers.put(caller, "suspended");
                    caller.suspend(this, timeout, realtime);
                    this.icallers.remove(caller);
                }
            }
            ret = this.hasNextIntermediateResult(timeout, realtime);
        }
        return ret;
    }

    @Override
    public E getNextIntermediateResult() {
        return this.getNextIntermediateResult(false);
    }

    public E getNextIntermediateResult(boolean realtime) {
        return this.getNextIntermediateResult(-2L, realtime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E getNextIntermediateResult(long timeout, boolean realtime) {
        Integer index;
        IntermediateFuture intermediateFuture = this;
        synchronized (intermediateFuture) {
            index = this.indices != null ? this.indices.get(Thread.currentThread()) : null;
            Integer n = index = index == null ? Integer.valueOf(1) : Integer.valueOf(index + 1);
            if (this.indices == null) {
                this.indices = new HashMap<Thread, Integer>();
            }
            this.indices.put(Thread.currentThread(), index);
        }
        return this.doGetNextIntermediateResult(index - 1, timeout, realtime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxResultCount(int max) {
        boolean notify = false;
        IntermediateFuture intermediateFuture = this;
        synchronized (intermediateFuture) {
            if (this.isDone()) {
                throw new IllegalStateException("Future already finished.");
            }
            if (this.maxresultcnt != -1) {
                throw new IllegalStateException("Max result count must only be set once.");
            }
            this.maxresultcnt = max;
            this.intermediate |= max != -1;
            if (this.hasResultListener()) {
                notify = this.scheduleMaxNotification(null);
            }
        }
        if (notify) {
            IntermediateFuture.startScheduledNotifications();
        }
        if (this.getResultCount() == max) {
            this.setFinishedIfUndone();
        }
    }

    protected boolean scheduleMaxNotification(IResultListener<Collection<E>> lis) {
        boolean donotify = false;
        if (this.maxresultcnt != -1) {
            donotify = true;
            ICommand com = new ICommand<IResultListener<Collection<E>>>(){

                public void execute(IResultListener<Collection<E>> listener) {
                    ((IIntermediateResultListener)listener).maxResultCountAvailable(IntermediateFuture.this.maxresultcnt);
                }

                public String toString() {
                    return "notifyMaxCount";
                }
            };
            if (lis == null) {
                this.scheduleNotification(l -> l instanceof IIntermediateResultListener, com);
            } else {
                this.scheduleNotification(lis, com);
            }
        }
        return donotify;
    }

    protected int getResultCount() {
        return this.results != null ? this.results.size() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected E doGetNextIntermediateResult(int index, long timeout, boolean realtime) {
        Object mon;
        E ret = null;
        boolean suspend = false;
        ISuspendable caller = ISuspendable.SUSPENDABLE.get();
        if (caller == null) {
            caller = new ThreadSuspendable();
        }
        IntermediateFuture intermediateFuture = this;
        synchronized (intermediateFuture) {
            if (this.results != null && this.results.size() > index) {
                Iterator<E> it = this.results.iterator();
                for (int i = 0; i <= index; ++i) {
                    ret = it.next();
                }
            } else if (this.isDone()) {
                if (this.getException() == null) throw new NoSuchElementException("No more intermediate results.");
                IntermediateFuture.throwException(this.getException());
            } else {
                suspend = true;
                if (this.icallers == null) {
                    this.icallers = Collections.synchronizedMap(new HashMap());
                }
                this.icallers.put(caller, "queued");
            }
        }
        if (!suspend) return ret;
        Object object = mon = caller.getMonitor() != null ? caller.getMonitor() : caller;
        synchronized (object) {
            String state = this.icallers.get(caller);
            if ("queued".equals(state)) {
                this.icallers.put(caller, "suspended");
                caller.suspend(this, timeout, realtime);
                this.icallers.remove(caller);
            }
        }
        ret = this.doGetNextIntermediateResult(index, timeout, realtime);
        return ret;
    }

    protected void notifyIntermediateResult(IIntermediateResultListener<E> listener, E result) {
        if (this.undone && listener instanceof IUndoneIntermediateResultListener) {
            IUndoneIntermediateResultListener ulistener = (IUndoneIntermediateResultListener)listener;
            ulistener.intermediateResultAvailableIfUndone(result);
        } else {
            listener.intermediateResultAvailable(result);
        }
    }

    @Override
    protected void resume() {
        super.resume();
        this.resumeIntermediate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resumeIntermediate() {
        IntermediateFuture intermediateFuture = this;
        synchronized (intermediateFuture) {
            ISuspendable[] callers;
            ISuspendable[] iSuspendableArray = callers = this.icallers != null ? this.icallers.keySet().toArray(new ISuspendable[0]) : null;
            if (callers != null) {
                for (ISuspendable caller : callers) {
                    Object mon;
                    Object object = mon = caller.getMonitor() != null ? caller.getMonitor() : caller;
                    synchronized (object) {
                        String state = this.icallers.get(caller);
                        if ("suspended".equals(state)) {
                            caller.resume(this);
                        }
                        this.icallers.put(caller, "resumed");
                    }
                }
            }
        }
    }

    @Override
    public void delegateFrom(IFuture<Collection<E>> source) {
        if (source == null) {
            throw new IllegalArgumentException("Source must not null");
        }
        source.addResultListener(new IntermediateDelegationResultListener(this));
    }

    @Override
    public IIntermediateFuture<E> catchEx(final Consumer<? super Exception> consumer, Class<?> futuretype) {
        IntermediateEmptyResultListener reslis = new IntermediateEmptyResultListener<E>(){

            @Override
            public void exceptionOccurred(Exception exception) {
                consumer.accept(exception);
            }
        };
        this.addResultListener(reslis);
        return this;
    }

    public <T> IIntermediateFuture<E> delegateEx(final Future<T> delegate) {
        IntermediateEmptyResultListener reslis = new IntermediateEmptyResultListener<E>(){

            @Override
            public void exceptionOccurred(Exception exception) {
                delegate.setException(exception);
            }
        };
        this.addResultListener(reslis);
        return this;
    }

    @Override
    public IIntermediateFuture<E> then(final Consumer<? super Collection<E>> function) {
        this.addResultListener(new IntermediateEmptyResultListener<E>(){

            @Override
            public void resultAvailable(Collection<E> result) {
                function.accept(result);
            }
        });
        return this;
    }

    @Override
    public IIntermediateFuture<? extends E> next(final Consumer<? super E> function) {
        this.addResultListener(new IntermediateEmptyResultListener<E>(){

            @Override
            public void intermediateResultAvailable(E result) {
                function.accept(result);
            }
        });
        return this;
    }

    @Override
    public IIntermediateFuture<? extends E> max(final Consumer<Integer> function) {
        this.addResultListener(new IntermediateEmptyResultListener<E>(){

            @Override
            public void maxResultCountAvailable(int max) {
                function.accept(max);
            }
        });
        return this;
    }

    @Override
    public IIntermediateFuture<? extends E> finished(final Consumer<Void> function) {
        this.addResultListener(new IntermediateEmptyResultListener<E>(){

            @Override
            public void finished() {
                function.accept(null);
            }
        });
        return this;
    }

    @Override
    public IIntermediateFuture<? extends E> done(final Consumer<? super Exception> consumer) {
        this.addResultListener(new IntermediateEmptyResultListener<E>(){

            @Override
            public void exceptionOccurred(Exception exception) {
                consumer.accept(exception);
            }

            @Override
            public void finished() {
                consumer.accept(null);
            }
        });
        return this;
    }

    @Override
    public Stream<E> asStream() {
        return this.asStream(-2L, false);
    }

    @Override
    public Stream<E> asStream(final long timeout, final boolean realtime) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return IntermediateFuture.this.hasNextIntermediateResult(timeout, realtime);
            }

            @Override
            public E next() {
                return IntermediateFuture.this.getNextIntermediateResult(timeout, realtime);
            }
        }, 0), false);
    }
}

