/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.future;

import jadex.commons.future.DuplicateResultException;
import jadex.commons.future.Future;
import jadex.commons.future.IForwardCommandFuture;
import jadex.commons.future.IFutureCommandResultListener;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IUndoneIntermediateResultListener;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.logging.Logger;

public class IntermediateExceptionDelegationResultListener<E, T>
implements IIntermediateResultListener<E>,
IFutureCommandResultListener<Collection<E>>,
IUndoneIntermediateResultListener<E> {
    protected Future<T> future;
    protected boolean undone;
    protected Consumer<E> irlistener;
    protected Runnable flistener;
    protected Consumer<Integer> clistener;

    public IntermediateExceptionDelegationResultListener(Future<T> future, Consumer<E> irlistener, Runnable flistener, Consumer<Integer> clistener) {
        this(future);
        this.irlistener = irlistener;
        this.flistener = flistener;
        this.clistener = clistener;
    }

    public IntermediateExceptionDelegationResultListener(Future<T> future) {
        this.future = future;
    }

    @Override
    public void resultAvailable(Collection<E> result) {
        try {
            this.customResultAvailable(result);
        }
        catch (DuplicateResultException e) {
            if (e.getFuture() == this.future) {
                throw e;
            }
            if (this.undone) {
                this.future.setExceptionIfUndone(e);
            } else {
                this.future.setException(e);
            }
        }
        catch (Exception e) {
            if (this.undone) {
                this.future.setExceptionIfUndone(e);
            }
            this.future.setException(e);
        }
    }

    @Override
    public void intermediateResultAvailable(E result) {
        if (this.irlistener != null) {
            this.irlistener.accept(result);
        }
    }

    @Override
    public void finished() {
        if (this.flistener != null) {
            this.flistener.run();
        }
    }

    public void customResultAvailable(Collection<E> result) {
        for (E e : result) {
            this.intermediateResultAvailable(e);
        }
        this.finished();
    }

    @Override
    public void exceptionOccurred(Exception exception) {
        if (this.undone) {
            this.future.setExceptionIfUndone(exception);
        } else {
            this.future.setException(exception);
        }
    }

    @Override
    public void maxResultCountAvailable(int max) {
        if (this.clistener != null) {
            this.clistener.accept(max);
        }
    }

    @Override
    public void resultAvailableIfUndone(Collection<E> result) {
        this.undone = true;
        this.resultAvailable(result);
    }

    @Override
    public void exceptionOccurredIfUndone(Exception exception) {
        this.undone = true;
        this.exceptionOccurred(exception);
    }

    @Override
    public void intermediateResultAvailableIfUndone(E result) {
        this.undone = true;
        this.intermediateResultAvailable(result);
    }

    @Override
    public void finishedIfUndone() {
        this.undone = true;
        this.finished();
    }

    @Override
    public void commandAvailable(Object command) {
        if (this.future instanceof IForwardCommandFuture) {
            this.future.sendForwardCommand(command);
        } else {
            Logger.getLogger("intermediate-exception-delegation-result-listener").fine("Cannot forward command: " + this.future + " " + command);
        }
    }

    public boolean isUndone() {
        return this.undone;
    }
}

