/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.future;

import jadex.commons.future.DuplicateResultException;
import jadex.commons.future.IForwardCommandFuture;
import jadex.commons.future.IFutureCommandResultListener;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IUndoneIntermediateResultListener;
import jadex.commons.future.IUndoneResultListener;
import jadex.commons.future.IntermediateFuture;
import java.util.Collection;
import java.util.logging.Logger;

public class IntermediateDelegationResultListener<E>
implements IFutureCommandResultListener<Collection<E>>,
IUndoneIntermediateResultListener<E> {
    protected IntermediateFuture<E> future;
    protected boolean undone;
    protected IIntermediateResultListener<E> delegate;

    public IntermediateDelegationResultListener(IIntermediateResultListener<E> delegate) {
        this(delegate, false);
    }

    public IntermediateDelegationResultListener(IIntermediateResultListener<E> delegate, boolean undone) {
        this.delegate = delegate;
        this.undone = undone;
    }

    public IntermediateDelegationResultListener(IntermediateFuture<E> future) {
        this(future, false);
    }

    public IntermediateDelegationResultListener(IntermediateFuture<E> future, boolean undone) {
        this.future = future;
        this.undone = undone;
    }

    @Override
    public final void resultAvailable(Collection<E> result) {
        try {
            this.customResultAvailable(result);
        }
        catch (DuplicateResultException e) {
            if (e.getFuture() == this.future) {
                throw e;
            }
            this.handleException(e);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public final void intermediateResultAvailable(E result) {
        try {
            this.customIntermediateResultAvailable(result);
        }
        catch (DuplicateResultException e) {
            if (e.getFuture() == this.future) {
                throw e;
            }
            this.handleException(e);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void finished() {
        if (this.delegate != null) {
            if (this.undone && this.delegate instanceof IUndoneIntermediateResultListener) {
                ((IUndoneIntermediateResultListener)this.delegate).finishedIfUndone();
            } else {
                this.delegate.finished();
            }
        } else if (this.undone) {
            this.future.setFinishedIfUndone();
        } else {
            this.future.setFinished();
        }
    }

    public void customResultAvailable(Collection<E> result) {
        if (this.delegate != null) {
            if (this.undone && this.delegate instanceof IUndoneResultListener) {
                ((IUndoneIntermediateResultListener)this.delegate).resultAvailableIfUndone(result);
            } else {
                this.delegate.resultAvailable(result);
            }
        } else if (this.undone) {
            this.future.setResultIfUndone(result);
        } else {
            this.future.setResult(result);
        }
    }

    @Override
    public void exceptionOccurred(Exception exception) {
        if (this.delegate != null) {
            if (this.undone && this.delegate instanceof IUndoneResultListener) {
                ((IUndoneIntermediateResultListener)this.delegate).exceptionOccurredIfUndone(exception);
            } else {
                this.delegate.exceptionOccurred(exception);
            }
        } else if (this.undone) {
            this.future.setExceptionIfUndone(exception);
        } else {
            this.future.setException(exception);
        }
    }

    public void customIntermediateResultAvailable(E result) {
        if (this.delegate != null) {
            if (this.undone && this.delegate instanceof IUndoneIntermediateResultListener) {
                ((IUndoneIntermediateResultListener)this.delegate).intermediateResultAvailableIfUndone(result);
            } else {
                this.delegate.intermediateResultAvailable(result);
            }
        } else if (this.undone) {
            this.future.addIntermediateResultIfUndone(result);
        } else {
            this.future.addIntermediateResult(result);
        }
    }

    @Override
    public void maxResultCountAvailable(int max) {
        if (this.delegate != null) {
            this.delegate.maxResultCountAvailable(max);
        } else {
            this.future.setMaxResultCount(max);
        }
    }

    @Override
    public void commandAvailable(Object command) {
        if (this.delegate instanceof IFutureCommandResultListener) {
            ((IFutureCommandResultListener)((Object)this.delegate)).commandAvailable(command);
        }
        if (this.future instanceof IForwardCommandFuture) {
            this.future.sendForwardCommand(command);
        } else {
            Logger.getLogger("intermediate-delegation-result-listener").fine("Cannot forward command: " + this.future + " " + command);
        }
    }

    @Override
    public void resultAvailableIfUndone(Collection<E> result) {
        this.undone = true;
        this.resultAvailable(result);
    }

    @Override
    public void exceptionOccurredIfUndone(Exception exception) {
        this.undone = true;
        this.exceptionOccurred(exception);
    }

    @Override
    public void intermediateResultAvailableIfUndone(E result) {
        this.undone = true;
        this.intermediateResultAvailable(result);
    }

    @Override
    public void finishedIfUndone() {
        this.undone = true;
        this.finished();
    }

    protected void handleException(Exception e) {
        if (this.future != null) {
            this.future.setExceptionIfUndone(e);
        } else if (this.undone && this.delegate instanceof IUndoneResultListener) {
            ((IUndoneIntermediateResultListener)this.delegate).exceptionOccurredIfUndone(e);
        } else {
            this.delegate.exceptionOccurred(e);
        }
    }
}

